/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.creditgame.AddCreditExceptionRecordDto;
import cn.com.duiba.activity.center.api.dto.creditgame.QueryParameters;
import cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteAddCreditExceptionService;
import cn.com.duiba.activity.center.biz.entity.creditgame.AddCreditExceptionRecordEntity;
import cn.com.duiba.activity.center.biz.service.creditgame.AddCreditExceptionRecordService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteAddCreditExceptionServiceImpl
implements RemoteAddCreditExceptionService {
    @Resource
    private AddCreditExceptionRecordService addCreditExceptionRecordService;
    private static Logger log = LoggerFactory.getLogger(RemoteAddCreditExceptionServiceImpl.class);

    public DubboResult<Boolean> add(AddCreditExceptionRecordDto dto) {
        try {
            AddCreditExceptionRecordEntity entity = new AddCreditExceptionRecordEntity();
            ObjectUtil.convert((Object)dto, (Object)entity);
            int recorde = this.addCreditExceptionRecordService.insert(entity);
            if (recorde == 1) {
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            return DubboResult.failResult((String)"");
        }
        catch (Exception e) {
            log.error("\u52a0\u79ef\u5206\u5f02\u5e38\u8bb0\u5f55\u6dfb\u52a0\u51fa\u9519", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PaginationDto<AddCreditExceptionRecordDto>> findPage(QueryParameters params, PagingParameters pageparams) {
        try {
            PaginationDto rs = new PaginationDto();
            Integer offset = pageparams.getOffset();
            Integer max = pageparams.getMax();
            String orderNum = params.getOrderNum();
            List appIds = params.getAppIds();
            Byte exceptionType = params.getExceptionType();
            Date start = params.getStart();
            Date end = params.getEnd();
            if (StringUtils.isBlank((CharSequence)orderNum)) {
                orderNum = null;
            }
            if (CollectionUtils.isEmpty((Collection)appIds)) {
                appIds = null;
            }
            Long count = this.addCreditExceptionRecordService.findCount(orderNum, appIds, exceptionType, start, end);
            ArrayList dtos = Lists.newArrayList();
            if (count != null && count > 0L) {
                List<AddCreditExceptionRecordEntity> entitys = this.addCreditExceptionRecordService.findPage(orderNum, appIds, exceptionType, start, end, offset, max);
                ObjectUtil.convertList(entitys, (List)dtos, AddCreditExceptionRecordDto.class);
            } else {
                count = 0L;
            }
            rs.setRows((List)dtos);
            rs.setTotalCount(count);
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("\u52a0\u79ef\u5206\u8bb0\u5f55\u67e5\u8be2\u51fa\u9519", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

