/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppListDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppSaveResultDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.activity.center.api.remoteservice.elasticgifts.RemoteElasticGiftsAppBackendService;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteElasticGiftsAppBackendService")
public class RemoteElasticGiftsAppBackendServiceImpl
implements RemoteElasticGiftsAppBackendService {
    private static Logger LOGGER = LoggerFactory.getLogger(RemoteElasticGiftsAppBackendServiceImpl.class);
    @Autowired
    private ElasticGiftsAppService elasticGiftsAppService;

    public DubboResult<List<ElasticGiftsAppListDto>> getAllElasticGiftsApps(ElasticGiftsBizCodeEnum bizCode, Long activityId) {
        try {
            List<ElasticGiftsAppListDto> result = this.elasticGiftsAppService.getAllElasticGiftsApps(bizCode, activityId);
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            LOGGER.error("getAllElasticGiftsApps error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> delete(ElasticGiftsBizCodeEnum bizCode, List<Long> appIds) {
        try {
            Boolean result = this.elasticGiftsAppService.delete(bizCode, appIds);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("delete error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ElasticGiftsAppSaveResultDto>> save(List<Long> toDeleteIds, ElasticGiftsBizCodeEnum bizCode, List<Long> appIds, Long activityId) {
        try {
            List<ElasticGiftsAppSaveResultDto> result = this.elasticGiftsAppService.save(toDeleteIds, bizCode, appIds, activityId);
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            LOGGER.error("save error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> saveElasticGiftsIdByAppId(Long elasticGiftsId, Long appId, ElasticGiftsBizCodeEnum bizCode) {
        try {
            Boolean result = this.elasticGiftsAppService.saveElasticGiftsIdByAppId(elasticGiftsId, appId, bizCode);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("saveElasticGiftsIdByAppId error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

