/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.rob.category;

import cn.com.duiba.activity.center.api.dto.rob.category.RobBarCategoryRelationDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryBarDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.category.RemoteRobCategoryBarService;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarEntity;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryEntity;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryBarService;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RemoteRobCategoryBarServiceImpl
implements RemoteRobCategoryBarService {
    @Autowired
    private RobCategoryBarService robCategoryBarService;
    @Autowired
    private RobCategoryService robCategoryService;

    public DubboResult<List<RobCategoryBarDto>> getPagByName(String name, Integer offset, Integer pageSize) {
        List<RobCategoryBarEntity> robCategoryBarEntityList = this.robCategoryBarService.getPagByName(name, offset, pageSize);
        return DubboResult.successResult(this.robCategoryBarEntityToDtoList(robCategoryBarEntityList));
    }

    public DubboResult<Integer> countByName(String name) {
        return DubboResult.successResult((Object)this.robCategoryBarService.countByName(name));
    }

    public DubboResult<Boolean> deleteBarById(Long barId) {
        return DubboResult.successResult((Object)this.robCategoryBarService.deleteBarById(barId));
    }

    public DubboResult<Boolean> insertRobCategoryBar(String name, List<RobBarCategoryRelationDto> relationDtos) {
        if (!CollectionUtils.isEmpty(relationDtos)) {
            for (RobBarCategoryRelationDto relationDto : relationDtos) {
                RobCategoryEntity robCategoryEntity = this.robCategoryService.getCategoryById(relationDto.getCategoryId());
                if (robCategoryEntity != null) continue;
                return DubboResult.failResult((String)("\u5206\u7c7bid=" + relationDto.getCategoryId() + "\u7684\u5206\u7c7b\u4e0d\u5b58\u5728"));
            }
        }
        return DubboResult.successResult((Object)this.robCategoryBarService.insertRobCategoryBar(name, relationDtos));
    }

    public DubboResult<RobCategoryBarDto> getRobCategoryBarById(Long barId) {
        RobCategoryBarEntity robCategoryBarEntity = this.robCategoryBarService.getRobCategoryBarById(barId);
        if (robCategoryBarEntity == null) {
            return DubboResult.failResult((String)"\u5206\u7c7b\u680f\u4e0d\u5b58\u5728");
        }
        return DubboResult.successResult((Object)this.robCategoryBarEntityToDto(robCategoryBarEntity));
    }

    public DubboResult<List<Long>> getRobCategoryIdsBarById(Long barId) {
        return DubboResult.successResult(this.robCategoryBarService.getRobCategoryIdsBarById(barId));
    }

    public DubboResult<List<RobCategoryBarDto>> getAllCategoryBarList() {
        List<RobCategoryBarEntity> robCategoryBarEntityList = this.robCategoryBarService.getAllCategoryBarList();
        return DubboResult.successResult(this.robCategoryBarEntityToDtoList(robCategoryBarEntityList));
    }

    public DubboResult<Boolean> updateCategoryBar(Long barId, String name, List<RobBarCategoryRelationDto> relationDtos) {
        return DubboResult.successResult((Object)this.robCategoryBarService.updateCategoryBar(barId, name, relationDtos));
    }

    private List<RobCategoryBarDto> robCategoryBarEntityToDtoList(List<RobCategoryBarEntity> robCategoryBarEntityList) {
        ArrayList<RobCategoryBarDto> robCategoryBarDtoList = new ArrayList<RobCategoryBarDto>();
        if (CollectionUtils.isEmpty(robCategoryBarEntityList)) {
            return robCategoryBarDtoList;
        }
        for (RobCategoryBarEntity entity : robCategoryBarEntityList) {
            robCategoryBarDtoList.add(this.robCategoryBarEntityToDto(entity));
        }
        return robCategoryBarDtoList;
    }

    private RobCategoryBarDto robCategoryBarEntityToDto(RobCategoryBarEntity robCategoryBarEntity) {
        return new RobCategoryBarDto(robCategoryBarEntity.getId(), robCategoryBarEntity.getName());
    }
}

