/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameBrickDto;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameBrickDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameBrickEntity;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameBrickService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaNgameBrickServiceImpl
implements DuibaNgameBrickService {
    @Resource
    private DuibaNgameBrickDao duibaNgameBrickDao;
    @Resource
    private CacheClient cacheClient;

    @Override
    public DuibaNgameBrickDto find(Long id) {
        return (DuibaNgameBrickDto)BeanUtils.copy((Object)this.duibaNgameBrickDao.find(id), DuibaNgameBrickDto.class);
    }

    @Override
    public void insert(DuibaNgameBrickDto duibaNgameBrickDto) {
        DuibaNgameBrickEntity e = (DuibaNgameBrickEntity)BeanUtils.copy((Object)duibaNgameBrickDto, DuibaNgameBrickEntity.class);
        this.duibaNgameBrickDao.insert(e);
        duibaNgameBrickDto.setId(e.getId());
    }

    @Override
    public void update4Admin(DuibaNgameBrickDto duibaNgameBrickDto) {
        this.duibaNgameBrickDao.update4Admin((DuibaNgameBrickEntity)BeanUtils.copy((Object)duibaNgameBrickDto, DuibaNgameBrickEntity.class));
        this.cacheClient.remove(this.getNoContentCacheKeyById(duibaNgameBrickDto.getId()));
        this.cacheClient.remove(this.getContentCacheKeyById(duibaNgameBrickDto.getId()));
    }

    @Override
    public DuibaNgameBrickDto findByTitle(String title) {
        return (DuibaNgameBrickDto)BeanUtils.copy((Object)this.duibaNgameBrickDao.findByTitle(title), DuibaNgameBrickDto.class);
    }

    @Override
    public void open(Long id) {
        this.duibaNgameBrickDao.open(id);
        this.cacheClient.remove(this.getNoContentCacheKeyById(id));
    }

    @Override
    public void disable(Long id) {
        this.duibaNgameBrickDao.disable(id);
        this.cacheClient.remove(this.getNoContentCacheKeyById(id));
    }

    @Override
    public List<DuibaNgameBrickDto> findPage(Integer offset, Integer max) {
        return BeanUtils.copyList(this.duibaNgameBrickDao.findPage(offset, max), DuibaNgameBrickDto.class);
    }

    @Override
    public Long findPageCount() {
        return this.duibaNgameBrickDao.findPageCount();
    }

    @Override
    public List<DuibaNgameBrickDto> findAll() {
        return BeanUtils.copyList(this.duibaNgameBrickDao.findAll(), DuibaNgameBrickDto.class);
    }

    @Override
    public String getBrickContentById(final Long id) {
        return (String)this.cacheClient.getWithCacheLoader(this.getContentCacheKeyById(id), 1, TimeUnit.HOURS, (CacheLoader)new CacheLoader<String>(){

            public String load() {
                return DuibaNgameBrickServiceImpl.this.duibaNgameBrickDao.getBrickContentById(id);
            }
        });
    }

    private String getNoContentCacheKeyById(Long id) {
        return "activity-duibaNgameBrickNoContentById_" + id;
    }

    private String getContentCacheKeyById(Long id) {
        return "activity-duibaNgameBrickContentById_" + id;
    }

    @Override
    public DuibaNgameBrickDto findNoContent(final Long id) {
        return (DuibaNgameBrickDto)this.cacheClient.getWithCacheLoader(this.getNoContentCacheKeyById(id), 20, TimeUnit.MINUTES, (CacheLoader)new CacheLoader<DuibaNgameBrickDto>(){

            public DuibaNgameBrickDto load() {
                return (DuibaNgameBrickDto)BeanUtils.copy((Object)DuibaNgameBrickServiceImpl.this.duibaNgameBrickDao.findNoContent(id), DuibaNgameBrickDto.class);
            }
        });
    }
}

