/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameOptionsDto;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameOptionsDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameOptionsEntity;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameOptionsService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaNgameOptionsServiceImpl
implements DuibaNgameOptionsService {
    @Resource
    private DuibaNgameOptionsDao duibaNgameOptionsDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-duibaNgameOptionsById_" + id;
    }

    @Override
    public void update(DuibaNgameOptionsDto duibaNgameOptionsDto) {
        this.duibaNgameOptionsDao.update((DuibaNgameOptionsEntity)BeanUtils.copy((Object)duibaNgameOptionsDto, DuibaNgameOptionsEntity.class));
        this.cacheClient.remove(this.getCacheKeyById(duibaNgameOptionsDto.getId()));
    }

    @Override
    public void addBatch(List<DuibaNgameOptionsDto> list) {
        this.duibaNgameOptionsDao.addBatch(BeanUtils.copyList(list, DuibaNgameOptionsEntity.class));
    }

    @Override
    public void add(DuibaNgameOptionsDto duibaNgameOptionsDto) {
        DuibaNgameOptionsEntity e = (DuibaNgameOptionsEntity)BeanUtils.copy((Object)duibaNgameOptionsDto, DuibaNgameOptionsEntity.class);
        this.duibaNgameOptionsDao.add(e);
        duibaNgameOptionsDto.setId(e.getId());
    }

    @Override
    public List<DuibaNgameOptionsDto> findByGameId(Long duibaNgameId) {
        return BeanUtils.copyList(this.duibaNgameOptionsDao.findByGameId(duibaNgameId), DuibaNgameOptionsDto.class);
    }

    @Override
    public Map<Long, List<DuibaNgameOptionsDto>> findByGameIds(List<Long> duibaNgameIds) {
        List<DuibaNgameOptionsEntity> list = this.duibaNgameOptionsDao.findByGameIds(duibaNgameIds);
        HashMap<Long, List<DuibaNgameOptionsDto>> map = new HashMap<Long, List<DuibaNgameOptionsDto>>();
        for (DuibaNgameOptionsEntity e : list) {
            ArrayList<Object> innerList = (ArrayList<Object>)map.get(e.getDuibaGameId());
            if (innerList == null) {
                innerList = new ArrayList<Object>();
                map.put(e.getDuibaGameId(), innerList);
            }
            innerList.add(BeanUtils.copy((Object)e, DuibaNgameOptionsDto.class));
        }
        return map;
    }

    @Override
    public void delete(Long id) {
        this.duibaNgameOptionsDao.delete(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public Integer countBigPrizeByGameId(Long duibaNgameId) {
        return this.duibaNgameOptionsDao.countBigPrizeByGameId(duibaNgameId);
    }

    @Override
    public DuibaNgameOptionsDto find(final Long id) {
        return (DuibaNgameOptionsDto)this.cacheClient.getWithCacheLoader(this.getCacheKeyById(id), 20, TimeUnit.MINUTES, (CacheLoader)new CacheLoader<DuibaNgameOptionsDto>(){

            public DuibaNgameOptionsDto load() {
                return (DuibaNgameOptionsDto)BeanUtils.copy((Object)DuibaNgameOptionsServiceImpl.this.duibaNgameOptionsDao.find(id), DuibaNgameOptionsDto.class);
            }
        });
    }

    @Override
    public List<DuibaNgameOptionsDto> findByAutoOpen(Long ngameId, boolean autoOpen) {
        return BeanUtils.copyList(this.duibaNgameOptionsDao.findByAutoOpen(ngameId, autoOpen), DuibaNgameOptionsDto.class);
    }

    @Override
    public List<DuibaNgameOptionsDto> findByAutoOpenDesc(Long ngameId, boolean autoOpen) {
        return BeanUtils.copyList(this.duibaNgameOptionsDao.findByAutoOpenDesc(ngameId, autoOpen), DuibaNgameOptionsDto.class);
    }

    @Override
    public List<DuibaNgameOptionsDto> findDisplayOption(Long ngameId) {
        return BeanUtils.copyList(this.duibaNgameOptionsDao.findDisplayOption(ngameId), DuibaNgameOptionsDto.class);
    }
}

