/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.ngame_con.impl;

import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersDto;
import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersExtendDto;
import cn.com.duiba.activity.center.biz.dao.ngame_con.NgameOrdersConsumerDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersEntity;
import cn.com.duiba.activity.center.biz.kafka.NgameMQSend;
import cn.com.duiba.activity.center.biz.service.ngame.NgameOrdersExtendService;
import cn.com.duiba.activity.center.biz.service.ngame.NgameOrdersService;
import cn.com.duiba.activity.center.biz.service.ngame_con.NgameOrdersConsumerService;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NgameOrdersConsumerServiceImpl
implements NgameOrdersConsumerService {
    private static Logger log = LoggerFactory.getLogger(NgameOrdersConsumerServiceImpl.class);
    @Resource
    private NgameOrdersConsumerDao ngameOrdersConsumerDao;
    @Autowired
    private NgameOrdersService ngameOrdersService;
    @Autowired
    private NgameOrdersExtendService ngameOrdersExtendService;
    @Autowired
    private NgameMQSend ngameMQSend;

    private String getCacheKey(Long consumerId, Long gameOrderId) {
        return "activity-NGAME_ORDERS_APP_BY_CONSUMER_ID_ORDERID_" + consumerId + "_" + gameOrderId;
    }

    @Override
    public NgameOrdersDto find(Long consumerId, Long gameOrderId) {
        return (NgameOrdersDto)BeanUtils.copy((Object)this.ngameOrdersConsumerDao.find(consumerId, gameOrderId), NgameOrdersDto.class);
    }

    @Override
    public Integer findConsumerFreeNumber(Long consumerId, Long operatingActivityId) {
        return this.ngameOrdersConsumerDao.findConsumerFreeNumber(consumerId, operatingActivityId);
    }

    @Override
    public Integer findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return this.ngameOrdersConsumerDao.findConsumerFreeNumberByDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer findConsumerLimitNumber(Long consumerId, Long operatingActivityId) {
        return this.ngameOrdersConsumerDao.findConsumerLimitNumber(consumerId, operatingActivityId);
    }

    @Override
    public Integer findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return this.ngameOrdersConsumerDao.findConsumerLimitNumberByDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public List<NgameOrdersDto> findByIds(Long consumerId, List<Long> ids) {
        return BeanUtils.copyList(this.ngameOrdersConsumerDao.findByIds(consumerId, ids), NgameOrdersDto.class);
    }

    @Override
    public void insert(NgameOrdersDto ngameOrdersDto) {
        NgameOrdersEntity e = (NgameOrdersEntity)BeanUtils.copy((Object)ngameOrdersDto, NgameOrdersEntity.class);
        int ret = this.ngameOrdersConsumerDao.insert(e);
        ngameOrdersDto.setId(e.getId());
        NgameOrdersExtendDto noe = new NgameOrdersExtendDto(true);
        noe.setGameOrderId(ngameOrdersDto.getId());
        this.ngameOrdersExtendService.insert(noe);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(ngameOrdersDto.getConsumerId(), ngameOrdersDto.getId());
        }
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        int ret = this.ngameOrdersConsumerDao.updateDeveloperBizId(consumerId, id, bizId);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        int ret = this.ngameOrdersConsumerDao.updateMainOrderId(consumerId, id, mainOrderId, mainOrderNum);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId) {
        int ret = this.ngameOrdersConsumerDao.updateStatusToConsumeSuccess(consumerId, gameOrderId);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateStatusToSuccess(Long consumerId, Long gameOrderId, Long gameOrderExtraId) {
        int ret = this.ngameOrdersConsumerDao.updateStatusToSuccess(consumerId, gameOrderId, gameOrderExtraId);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.ngameOrdersConsumerDao.updateStatusToFail(consumerId, gameOrderId, error4admin, error4developer, error4consumer);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpen(Long consumerId, Long gameOrderId, String gameDataStr) {
        int ret = this.ngameOrdersConsumerDao.updateExchangeStatusToWaitOpen(consumerId, gameOrderId, gameDataStr);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        this.ngameOrdersExtendService.updateGameData(gameOrderId, gameDataStr);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId, Long gameOrderId, String gameDataStr, Long gameOrderExtraId) {
        int ret = this.ngameOrdersConsumerDao.updateExchangeStatusToWaitOpenAndExtraId(consumerId, gameOrderId, gameDataStr, gameOrderExtraId);
        this.ngameOrdersExtendService.updateGameData(gameOrderId, gameDataStr);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWait(Long consumerId, Long gameOrderId, String gameDataStr, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        int ret = this.ngameOrdersConsumerDao.updateExchangeStatusToWait(consumerId, gameOrderId, gameDataStr, itemId, appItemId, prizeId, prizeType, prizeName, prizeFacePrice, couponId);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        this.ngameOrdersExtendService.updateGameData(gameOrderId, gameDataStr);
        return ret;
    }

    @Override
    public int updateExchangeStatusToOverdue(Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        NgameOrdersDto order = this.ngameOrdersService.find(gameOrderId);
        int ret = this.ngameOrdersConsumerDao.updateExchangeStatusToOverdue(gameOrderId, order.getConsumerId(), error4admin, error4developer, error4consumer);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(order.getConsumerId(), gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.ngameOrdersConsumerDao.updateExchangeStatusToFail(consumerId, gameOrderId, error4admin, error4developer, error4consumer);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int doTakePrize(Long consumerId, Long gameOrderId) {
        int ret = this.ngameOrdersConsumerDao.doTakePrize(consumerId, gameOrderId);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int rollbackTakePrize(Long consumerId, Long gameOrderId) {
        int ret = this.ngameOrdersConsumerDao.rollbackTakePrize(consumerId, gameOrderId);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        int ret = this.ngameOrdersConsumerDao.updateManualOpenPrizeExchangeStatusToWait(consumerId, gameOrderId, itemId, appItemId, prizeId, prizeType, prizeName, prizeFacePrice, couponId);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long gameOrderId, Long gameOrderExtraId) {
        int ret = this.ngameOrdersConsumerDao.updateExchangeStatusToWaitOpenAndExtraIdForLuck(consumerId, gameOrderId, gameOrderExtraId);
        if (ret == 1) {
            this.ngameMQSend.ngameSendDataSync(consumerId, gameOrderId);
        }
        return ret;
    }
}

