/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.bo.rob.impl;

import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.params.TodayRobFloorParams;
import cn.com.duiba.activity.center.biz.bo.rob.TodayRobFloorBo;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TodayRobFloorBoImpl
implements TodayRobFloorBo {
    @Autowired
    private TodayRobConfigService todayRobConfigService;
    @Autowired
    private DeveloperActBlackService developerActBlackService;
    @Autowired
    private DuibaActivityAppSpecifyNewService duibaActivityAppSpecifyNewService;
    private static final Integer LoadMax = 21;

    @Override
    public List<TodayRobConfigDto> findFloorTodayRobList(TodayRobFloorParams params) {
        List<TodayRobConfigDto> allList = this.todayRobConfigService.findSortTodayRobConfig(0, LoadMax);
        allList = this.blackFilter(params.getDeveloperId(), allList);
        allList = this.specifyFilter(params.getAppId(), allList);
        if (allList.size() > params.getSize()) {
            allList = allList.subList(0, params.getSize());
        }
        return allList;
    }

    private List<TodayRobConfigDto> blackFilter(Long developId, List<TodayRobConfigDto> list) {
        ArrayList newList = Lists.newArrayList();
        for (TodayRobConfigDto dto : list) {
            Boolean blackResult;
            if (dto.isOpenSwitch(TodayRobConfigDto.SWITCHES_DEV_BLACKLIST.intValue()) && (blackResult = this.isExistBlackByActivityIdAndActivityTypeAndDeveloperId(dto.getId(), 45, developId)).booleanValue()) continue;
            newList.add(dto);
        }
        return newList;
    }

    private List<TodayRobConfigDto> specifyFilter(Long appId, List<TodayRobConfigDto> list) {
        ArrayList newList = Lists.newArrayList();
        ArrayList specifyActivityIds = Lists.newArrayList();
        for (TodayRobConfigDto dto : list) {
            if (!dto.isOpenSwitch(TodayRobConfigDto.SWITCHES_DIRECT.intValue())) continue;
            specifyActivityIds.add(dto.getId());
        }
        List<Long> tt = this.duibaActivityAppSpecifyNewService.batchFindIsSpecifyActivityIds(specifyActivityIds, appId, "rob");
        HashSet activityIds = Sets.newHashSet(tt);
        for (TodayRobConfigDto dto : list) {
            if (dto.isOpenSwitch(TodayRobConfigDto.SWITCHES_DIRECT.intValue()) && !activityIds.contains(dto.getId())) continue;
            newList.add(dto);
        }
        return newList;
    }

    private Boolean isExistBlackByActivityIdAndActivityTypeAndDeveloperId(Long activityId, Integer activityType, Long developerId) {
        ActivityBlackList4DeveloperDto dto = new ActivityBlackList4DeveloperDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setDeveloperId(developerId);
        Boolean bo = this.developerActBlackService.getBlackCache(dto);
        if (null == bo) {
            Integer result = this.developerActBlackService.query(dto);
            Boolean bolresult = false;
            if (result > 0) {
                bolresult = true;
            }
            this.developerActBlackService.setBlackCache(dto, bolresult);
            return bolresult;
        }
        return bo;
    }
}

