/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.buckle.impl;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.dto.sign.SignConfigDto;
import cn.com.duiba.activity.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerSignService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.sign.SignFlowInnerService;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumerSignServiceImpl
implements ConsumerSignService {
    private static Logger log = LoggerFactory.getLogger(ConsumerSignServiceImpl.class);
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;
    @Autowired
    private SignFlowInnerService signFlowInnerService;

    @Override
    public void asyncConsumerPlug(Long consumerId, String orderNum, String transfer, String ip, String ua, String os, SignConfigDto signDto, Integer signDays) {
        DubboResult order = this.remoteActivityOrderService.findByOrderNum(orderNum);
        if (!order.isSuccess() || order.getResult() == null) {
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
            message.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
            message.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
            HashMap params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams((Map)params);
            this.onCreditsFail(message, new Exception("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728"));
            return;
        }
        CreditsCallbackMessage message = new CreditsCallbackMessage();
        message.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
        message.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
        message.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
        HashMap params = Maps.newHashMap();
        params.put("ip", ip);
        message.setParams((Map)params);
        this.onCreditsSuccess(message, ua, os, signDto, signDays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCreditsFail(CreditsCallbackMessage message, Exception exception) {
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
        try {
            ActivityOrderDto o4u = new ActivityOrderDto();
            if (exception instanceof DeveloperConsumeFailedException && ((DeveloperConsumeFailedException)exception).getNormalFail().booleanValue()) {
                o4u.setError4admin("\u6263\u79ef\u5206\u5931\u8d25\uff0c\u5f00\u53d1\u8005\u8fd4\u56de\u6263\u79ef\u5206\u5931\u8d25\u3002" + exception.getMessage());
                o4u.setError4developer("\u6263\u79ef\u5206\u5931\u8d25\uff0c\u5f00\u53d1\u8005\u8fd4\u56de\u6263\u79ef\u5206\u5931\u8d25\u3002");
                o4u.setError4consumer("\u62bd\u5956\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
            } else {
                o4u.setError4admin("\u6263\u79ef\u5206\u5931\u8d25\uff0c\u5f00\u53d1\u8005\u670d\u52a1\u5668\u5f02\u5e38\u3002" + exception.getMessage());
                o4u.setError4developer("\u6263\u79ef\u5206\u5931\u8d25\uff0c" + exception.getMessage());
                o4u.setError4consumer("\u62bd\u5956\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
            }
            this.remoteActivityOrderService.consumeCreditsFail(order.getOrderNum(), null, null, null, null, null, null, null, null, null, o4u.getError4admin(), o4u.getError4developer(), o4u.getError4consumer());
            if (order.getConsumeCredits() > 0L) {
                this.remoteConsumerService.increaseCredits(order.getConsumerId(), order.getConsumeCredits());
            }
        }
        catch (Exception e) {
            log.error("\u6d3b\u52a8\u62bd\u5956\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            this.complete(order.getOrderNum());
            DuibaEventsDispatcher.get().dispatchConsumeCreditsFailEvent(new ConsumeCreditsFailEvent(order, exception));
        }
    }

    private void complete(String orderNum) {
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        if (order.getConsumeCreditsStatus() == 2) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderSuccess, order));
        } else if (order.getConsumeCreditsStatus() == 3) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderFail, order));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCreditsSuccess(CreditsCallbackMessage message, String ua, String os, SignConfigDto signDto, Integer signDays) {
        String ip = (String)message.getParams().get("ip");
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
        List<Object> options = Lists.newArrayList();
        if ("sign".equals(order.getActivityType())) {
            options = this.activityPrizeOptionService.queryActivityOptionsByConfigIdAndDays(order.getDuibaActivityId(), ActivityPrizeOptionDto.Activity_Type_Sign, signDays.toString());
        }
        ActivityPrizeOptionDto winOption = this.signFlowInnerService.randomPrize(order.getDuibaActivityId(), order.getActivityType(), options);
        try {
            winOption = this.signFlowInnerService.winOptionCheck(order, winOption, options);
            this.signFlowInnerService.doWinPrize(order, winOption, options, ip, ua, os, signDto);
        }
        catch (Exception e) {
            log.error("\u62bd\u5956\u5f02\u5e38:\u798f\u888b\uff0c\u82e5\u5956\u9879\u6ca1\u6709\u914d\u7f6e\u798f\u888b\u5219\u4e2d \u8c22\u8c22\u53c2\u4e0e", (Throwable)e);
            LogUtil.logTodayKan((String)("ConsumerPluginServiceImpl onCreditsSuccess \u6839\u636e\u6982\u7387\u9009\u53d6\u7684\u4e00\u4e2a\u5956\u9879 winOption===>" + JSONObject.toJSONString((Object)winOption)));
            try {
                ActivityPrizeOptionDto option = this.signFlowInnerService.awardOptionLuck(order.getDuibaActivityId(), order.getActivityType(), options);
                winOption = this.signFlowInnerService.winOptionCheck(order, option, options);
                this.signFlowInnerService.doWinPrize(order, winOption, options, ip, ua, os, signDto);
            }
            catch (Exception e1) {
                log.error("\u62bd\u5956\u5f02\u5e38,\u964d\u7ea7\u4e3a\u4f18\u60e0\u5238\u51fa\u9519:", (Throwable)e1);
                try {
                    ActivityPrizeOptionDto option = this.signFlowInnerService.awardThanks(order.getDuibaActivityId(), order.getActivityType());
                    this.remoteActivityOrderService.consumeCreditsSuccessDowngrade(order.getOrderNum(), option.getId(), option.getPrizeName(), option.getPrizeType(), option.getFacePrice(), option.getAppItemId(), option.getItemId(), option.getgId(), option.getgType(), null);
                }
                catch (Exception e3) {
                    log.error("\u62bd\u5956\u5f02\u5e38: \u964d\u7ea7\u4e3a\u8c22\u8c22\u53c2\u4e0e\uff0c\u4ecd\u7136\u51fa\u9519 ", (Throwable)e3);
                }
            }
        }
        finally {
            this.complete(order.getOrderNum());
            ActivityOrderDto orderNew = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
            DuibaEventsDispatcher.get().dispatchConsumeCreditsSuccessEvent(new ConsumerCreditsSuccessEvent(orderNew));
        }
    }
}

