/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.event;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEvent;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.pool.ThreadPoolDuibaService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuibaEventsDispatcher {
    private static Logger log = LoggerFactory.getLogger(DuibaEventsDispatcher.class);
    private static DuibaEventsDispatcher dispatcher = new DuibaEventsDispatcher();

    public static DuibaEventsDispatcher get() {
        return dispatcher;
    }

    public void dispatchEvent(DuibaEvent<?> e) {
        if (e instanceof ActivityOrdersEvent) {
            this.processActivityOrdersEvent((ActivityOrdersEvent)e);
        }
    }

    private void processActivityOrdersEvent(final ActivityOrdersEvent event) {
        final List<ActivityOrdersEvent.ActivityOrdersEventListener> listeners = DuibaEventsRegister.get().activityOrderListener;
        if (!listeners.isEmpty()) {
            ThreadPoolDuibaService.get().submit(new Runnable(){

                @Override
                public void run() {
                    for (ActivityOrdersEvent.ActivityOrdersEventListener l : new ArrayList(listeners)) {
                        try {
                            if (event.getType() == ActivityOrdersEvent.ActivityOrdersEventType.OnOrderCreate) {
                                l.onOrderCreate(event.getData());
                                continue;
                            }
                            if (event.getType() == ActivityOrdersEvent.ActivityOrdersEventType.OnOrderSuccess) {
                                l.onOrderSuccess(event.getData());
                                continue;
                            }
                            if (event.getType() != ActivityOrdersEvent.ActivityOrdersEventType.OnOrderFail) continue;
                            l.onOrderFail(event.getData());
                        }
                        catch (Exception e) {
                            log.error("processActivityOrderEvent", (Throwable)e);
                        }
                    }
                }
            }, 5);
        }
    }

    public void triggerAfterActivityOrderCreate(ActivityOrderDto order) {
        for (ActivityOrderSyncEvent p : new ArrayList<ActivityOrderSyncEvent>(DuibaEventsRegister.get().activityOrderPlugins)) {
            try {
                p.afterOrderCreate(order);
            }
            catch (Exception e) {
                log.error(p.getClass().getName() + " process error", (Throwable)e);
            }
        }
    }

    public void triggerBeforeActivityOrderComplete(ActivityOrderDto order, ActivityPrizeOptionDto option, ActivityOrderSyncEvent.ActivityOrderPluginContext context) throws Exception {
        for (ActivityOrderSyncEvent p : new ArrayList<ActivityOrderSyncEvent>(DuibaEventsRegister.get().activityOrderPlugins)) {
            log.error(p.getClass().getName() + "    \u6263\u5e93\u5b58\u65b9\u6cd5\u6267\u884c\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            p.beforeStockComplete(order, option, context);
        }
    }

    public void triggerOnActivityOrderCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option, Exception exception, ActivityOrderSyncEvent.ActivityOrderPluginContext context) {
        for (ActivityOrderSyncEvent p : new ArrayList<ActivityOrderSyncEvent>(DuibaEventsRegister.get().activityOrderPlugins)) {
            try {
                p.beforeStockCompleteException(order, option, exception, context);
            }
            catch (Exception e) {
                log.error(p.getClass().getName() + " process error", (Throwable)e);
            }
        }
    }

    public void dispatchConsumeCreditsFailEvent(final ConsumeCreditsFailEvent event) {
        if (event.getException() != null) {
            ThreadPoolDuibaService.get().submit(new Runnable(){

                @Override
                public void run() {
                    List<ConsumeCreditsFailEvent.ConsumeCreditsFailListener> listeners = DuibaEventsRegister.get().consumeCreditsFailListeners;
                    if (event.getActivityOrder() != null) {
                        for (ConsumeCreditsFailEvent.ConsumeCreditsFailListener l : listeners) {
                            try {
                                l.onConsumeActivityOrderFail(event.getActivityOrder(), event.getException());
                            }
                            catch (Exception e) {
                                log.error("dispatchConsumeCreditsFailEvent", (Throwable)e);
                            }
                        }
                    }
                }
            }, 1);
        }
    }

    public void dispatchConsumeCreditsSuccessEvent(final ConsumerCreditsSuccessEvent event) {
        ThreadPoolDuibaService.get().submit(new Runnable(){

            @Override
            public void run() {
                List<ConsumerCreditsSuccessEvent.ConsumeCreditsSuccessListener> listeners = DuibaEventsRegister.get().consumeCreditsSuccessListeners;
                if (event.getActivityOrder() != null) {
                    for (ConsumerCreditsSuccessEvent.ConsumeCreditsSuccessListener l : listeners) {
                        try {
                            l.onConsumeOrderSuccess(event.getActivityOrder());
                        }
                        catch (Exception e) {
                            log.error("dispatchConsumeCreditsSuccessEvent", (Throwable)e);
                        }
                    }
                }
            }
        }, 1);
    }
}

