/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.stock;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.dataobject.ItemAppSpecifyDO;
import cn.com.duiba.service.item.remoteservice.RemoteItemAppSpecifyService;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.item.remoteservice.RemoteItemStockConsumeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityDirectItemStockPluginImpl
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(ActivityDirectItemStockPluginImpl.class);
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemoteItemAppSpecifyService remoteItemAppSpecifyService;
    @Autowired
    private RemoteItemStockConsumeService remoteItemStockConsumeService;
    private ActivityOrderSyncEvent orderPlugin = new ActivityOrderSyncEvent(){
        private static final String ACTIVITY_REDIRECT_CONSUME_STOCK = "__activity_redirect_stock_consume";

        @Override
        public void afterOrderCreate(ActivityOrderDto order) {
        }

        @Override
        public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option, ActivityOrderSyncEvent.ActivityOrderPluginContext context) throws Exception {
            if (option.getPrizeType().equals("object") || option.getPrizeType().equals("coupon")) {
                try {
                    ItemAppSpecifyDO itemAppSpecifyDO;
                    ItemKey key = ActivityDirectItemStockPluginImpl.this.remoteItemKeyService.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                    if (key.getItem() != null && key.getItem().isOpTypeItem(3) && null != (itemAppSpecifyDO = ActivityDirectItemStockPluginImpl.this.remoteItemAppSpecifyService.findByItemIdAndAppId(key.getItem().getId(), key.getApp().getId()))) {
                        ActivityDirectItemStockPluginImpl.this.remoteItemStockConsumeService.consumeRedirectStock(key, order.getOrderNum(), "activityspecify");
                        context.setAttribute(ACTIVITY_REDIRECT_CONSUME_STOCK, true);
                    }
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: consumeStock,\u51cf\u5b9a\u5411\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            }
        }

        @Override
        public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option, Exception exception, ActivityOrderSyncEvent.ActivityOrderPluginContext context) {
            if (option.getPrizeType().equals("object") || option.getPrizeType().equals("coupon")) {
                try {
                    ItemAppSpecifyDO itemAppSpecifyDO;
                    ItemKey key = ActivityDirectItemStockPluginImpl.this.remoteItemKeyService.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                    if (key.getItem() != null && key.getItem().isOpTypeItem(3) && null != (itemAppSpecifyDO = ActivityDirectItemStockPluginImpl.this.remoteItemAppSpecifyService.findByItemIdAndAppId(key.getItem().getId(), key.getApp().getId()))) {
                        Boolean hasadd = (Boolean)context.getAttribute(ACTIVITY_REDIRECT_CONSUME_STOCK);
                        if (hasadd != null && hasadd.booleanValue()) {
                            ActivityDirectItemStockPluginImpl.this.remoteItemStockConsumeService.paybackRedirectStock(order.getOrderNum(), "activityspecify");
                        }
                        context.remove(ACTIVITY_REDIRECT_CONSUME_STOCK);
                    }
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: consumeStock,\u8fd4\u5b9a\u5411\u5e93\u5b58\u5931\u8d25", (Throwable)e);
                }
            }
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().addActivityOrdersPlugin(this.orderPlugin);
    }
}

