/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.advert;

import cn.com.duiba.activity.center.api.dto.advertising.DuibaAdMaterialDto;
import cn.com.duiba.activity.center.api.remoteservice.advertising.RemoteAdMaterialService;
import cn.com.duiba.activity.center.biz.entity.advert.DuibaAdMaterialEntity;
import cn.com.duiba.activity.center.biz.service.advert.DuibaAdMaterialService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteAdMaterialServiceImpl
implements RemoteAdMaterialService {
    private static final Logger log = LoggerFactory.getLogger(RemoteAdMaterialServiceImpl.class);
    @Resource
    private DuibaAdMaterialService duibaAdMaterialService;

    public DubboResult<DuibaAdMaterialDto> queryById(long materialId) {
        try {
            DuibaAdMaterialDto rs;
            DuibaAdMaterialEntity entity = this.duibaAdMaterialService.find(materialId);
            if (entity != null) {
                rs = new DuibaAdMaterialDto();
                ObjectUtil.convert((Object)entity, (Object)rs);
            } else {
                rs = null;
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteAdMaterialService.queryById(" + materialId + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<DuibaAdMaterialDto>> queryByIds(List<Long> ids) {
        try {
            ArrayList rs;
            if (CollectionUtils.isEmpty(ids)) {
                rs = null;
            } else {
                List<DuibaAdMaterialEntity> entities = this.duibaAdMaterialService.findByIds(ids);
                if (CollectionUtils.isEmpty(entities)) {
                    rs = null;
                } else {
                    rs = Lists.newArrayList();
                    ObjectUtil.convertList(entities, (List)rs, DuibaAdMaterialDto.class);
                }
            }
            return DubboResult.successResult(rs);
        }
        catch (Exception e) {
            log.error("RemoteAdMaterialService.queryByIds(" + ids.toString() + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<DuibaAdMaterialDto> add(DuibaAdMaterialDto dto) {
        try {
            Preconditions.checkNotNull((Object)dto);
            DuibaAdMaterialEntity entity = new DuibaAdMaterialEntity();
            ObjectUtil.convert((Object)dto, (Object)entity);
            Long id = this.duibaAdMaterialService.add(entity);
            if (id == null) {
                throw new Exception("duibaAdMaterialService.add error");
            }
            dto.setId(id);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("RemoteAdMaterialService.add() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> update(DuibaAdMaterialDto dto) {
        try {
            Preconditions.checkNotNull((Object)dto, (Object)"dto is null!");
            Preconditions.checkNotNull((Object)dto.getId(), (Object)"id is null!");
            DuibaAdMaterialEntity entity = new DuibaAdMaterialEntity();
            ObjectUtil.convert((Object)dto, (Object)entity);
            boolean rs = this.duibaAdMaterialService.update(entity);
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteAdMaterialService.update() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteById(long materialId) {
        try {
            boolean rs = this.duibaAdMaterialService.delete(materialId);
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteAdMaterialService.delete(" + materialId + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<DuibaAdMaterialDto> queryByActivity(Long activityId, Integer activityType) {
        try {
            DuibaAdMaterialDto rs;
            DuibaAdMaterialEntity entity = this.duibaAdMaterialService.findByActivity(activityId, activityType);
            if (entity != null) {
                rs = new DuibaAdMaterialDto();
                ObjectUtil.convert((Object)entity, (Object)rs);
            } else {
                rs = null;
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteAdMaterialService.queryByActivity(" + activityId + "," + activityType + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

