/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.impl;

import cn.com.duiba.activity.center.biz.dao.category.ActivityCategoryDao;
import cn.com.duiba.activity.center.biz.dao.category.ActivityCategorySpecifyDao;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;
import cn.com.duiba.activity.center.biz.entity.chaos.ActivityCategorySpecifyEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="activityCategoryService")
public class ActivityCategoryServiceImpl
implements ActivityCategoryService {
    @Autowired
    private ActivityCategoryDao activityCategoryDao;
    @Autowired
    private ActivityCategorySpecifyDao activityCategorySpecifyDao;

    @Override
    public Long createCategory(String name, String content) {
        ActivityCategoryEntity e = new ActivityCategoryEntity();
        e.setName(name);
        e.setContent(content);
        this.activityCategoryDao.insert(e);
        return e.getId();
    }

    @Override
    public Boolean editCategoryContent(long id, String name, String content) {
        int ret = this.activityCategoryDao.updateCategoryContent(id, name, content);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean enableCategory(long id) {
        int ret = this.activityCategoryDao.updateCategoryEnable(id);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean disableCategory(long id) {
        int ret = this.activityCategoryDao.updateCategoryDisable(id);
        if (ret == 1) {
            return true;
        }
        return false;
    }

    @Override
    public List<ActivityCategoryEntity> findAll() {
        return this.activityCategoryDao.selectAll();
    }

    @Override
    public List<ActivityCategoryEntity> findByIds(List<Long> ids) {
        return this.activityCategoryDao.findByIds(ids);
    }

    @Override
    public ActivityCategoryEntity findDefaultCategory() {
        List<ActivityCategoryEntity> list = this.findAll();
        for (ActivityCategoryEntity e : list) {
            if (!e.getDefaultCategory().booleanValue()) continue;
            return e;
        }
        return null;
    }

    @Override
    public ActivityCategoryEntity findById(long id) {
        return this.activityCategoryDao.select(id);
    }

    @Override
    public Boolean deleteCategory(long id) {
        int ret = this.activityCategoryDao.deleteById(id);
        return ret > 0;
    }

    @Override
    public List<ActivityCategoryEntity> findCategoryByAppId(Long appId) {
        List<ActivityCategoryEntity> enableCategoryList = this.activityCategoryDao.selectEnableCategory();
        List<ActivityCategorySpecifyEntity> specifyList = this.activityCategorySpecifyDao.selectByAppSpecifys(appId);
        ArrayList<Long> appSpecifyIdList = new ArrayList<Long>();
        for (ActivityCategorySpecifyEntity entity : specifyList) {
            appSpecifyIdList.add(entity.getActivityCategoryId());
        }
        Iterator<ActivityCategoryEntity> it = enableCategoryList.iterator();
        while (it.hasNext()) {
            ActivityCategoryEntity activityCategoryEntity = it.next();
            if (!activityCategoryEntity.getSpecify().booleanValue() || appSpecifyIdList.contains(activityCategoryEntity.getId())) continue;
            it.remove();
        }
        return enableCategoryList;
    }
}

