/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.sign.impl;

import cn.com.duiba.activity.center.api.dto.sign.SignConfigDto;
import cn.com.duiba.activity.center.biz.dao.sign.SignConfigDao;
import cn.com.duiba.activity.center.biz.entity.sign.SignConfigEntity;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerSignService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.service.sign.SignConfigService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignConfigServiceImpl
implements SignConfigService {
    private static Logger log = LoggerFactory.getLogger(SignConfigServiceImpl.class);
    @Resource
    private SignConfigDao signConfigDao;
    @Resource
    private CacheClient cacheClient;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private ConsumerSignService consumerSignService;

    private String getCacheKeyById(Long id) {
        return "activity-signConfigById_" + id;
    }

    @Override
    public List<SignConfigDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(this.signConfigDao.findAllByIds(ids), SignConfigDto.class);
    }

    @Override
    public List<SignConfigDto> findByPage(Long appId, Integer offset, Integer max, String title, Integer id) {
        return BeanUtils.copyList(this.signConfigDao.findByPage(appId, offset, max, title, id), SignConfigDto.class);
    }

    @Override
    public Long findByPageCount(Long appId, String title, Integer id) {
        return this.signConfigDao.findByPageCount(appId, title, id);
    }

    @Override
    public SignConfigDto find(final Long id) {
        return (SignConfigDto)this.cacheClient.getWithCacheLoader(this.getCacheKeyById(id), 30, TimeUnit.MINUTES, (CacheLoader)new CacheLoader<SignConfigDto>(){

            public SignConfigDto load() {
                return (SignConfigDto)BeanUtils.copy((Object)SignConfigServiceImpl.this.signConfigDao.find(id), SignConfigDto.class);
            }
        });
    }

    @Override
    public SignConfigDto add(SignConfigDto sign) {
        SignConfigEntity e = (SignConfigEntity)BeanUtils.copy((Object)sign, SignConfigEntity.class);
        this.signConfigDao.add(e);
        sign.setId(e.getId());
        return sign;
    }

    @Override
    public void delete(Long id) {
        this.signConfigDao.delete(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void update(SignConfigDto sign) {
        SignConfigEntity e = (SignConfigEntity)BeanUtils.copy((Object)sign, SignConfigEntity.class);
        this.signConfigDao.update(e);
        this.cacheClient.remove(this.getCacheKeyById(sign.getId()));
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        int ret = this.signConfigDao.updateStatus(id, status);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public String createOrder(Long consumerId, String transfer, String ip, String description, String ua, String os, SignConfigDto signDto, Integer signDays) {
        ConsumerDO consumer = this.remoteConsumerService.find(consumerId);
        String orderNum = this.createOrder(consumer, signDto, ip);
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderCreate, order));
        this.consumerSignService.asyncConsumerPlug(consumerId, orderNum, transfer, ip, ua, os, signDto, signDays);
        return orderNum;
    }

    private String createOrder(ConsumerDO consumer, SignConfigDto signDto, String ip) {
        ActivityOrderDto orderDto = new ActivityOrderDto();
        orderDto.setConsumerId(consumer.getId());
        orderDto.setAppId(consumer.getAppId());
        orderDto.setPartnerUserId(consumer.getPartnerUserId());
        orderDto.setDuibaActivityId(signDto.getId());
        orderDto.setActivityType("sign");
        orderDto.setConsumeCredits(Long.valueOf(0L));
        orderDto.setExchangeStatus(Integer.valueOf(1));
        orderDto.setAddCreditsStatus(Integer.valueOf(1));
        orderDto.setIp(ip);
        Date now = new Date();
        orderDto.setGmtCreate(now);
        orderDto.setGmtModified(now);
        String orderNum = null;
        try {
            orderNum = (String)this.remoteActivityOrderService.createOrder(orderDto).getResult();
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            throw e;
        }
        return orderNum;
    }
}

