/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.tools.service;

import cn.com.duiba.activity.center.biz.tools.XMemCacheClient;
import cn.com.duiba.activity.center.common.util.DateUtil;
import net.rubyeye.xmemcached.GetsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class AppTradingLimitService {
    private static Logger log = LoggerFactory.getLogger(AppTradingLimitService.class);
    private final String APP_NAMESPACE = "app_trading";
    @Autowired
    @Qualifier(value="memCacheClient")
    private XMemCacheClient xMemCacheClient;

    public Integer getTodayTradingCount(Long appId) {
        String key = "app_trading" + appId;
        Integer appItemCounter = 0;
        try {
            appItemCounter = (Integer)this.xMemCacheClient.getMemcachedClient().get(key);
            if (appItemCounter == null) {
                appItemCounter = 0;
            }
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
        }
        return appItemCounter;
    }

    public void addTrading(Long appId) {
        try {
            String key = "app_trading" + appId;
            if (this.setByCas(key, 1) == 2) {
                this.xMemCacheClient.getMemcachedClient().add(key, DateUtil.getToTomorrowSeconds(), (Object)1);
            }
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
        }
    }

    private Integer setByCas(String key, int type) {
        Integer result = null;
        try {
            int loopNum = 0;
            while (true) {
                if (loopNum >= 10) {
                    result = 1;
                    break;
                }
                GetsResponse last = this.xMemCacheClient.getMemcachedClient().gets(key);
                if (last == null) {
                    result = 2;
                    break;
                }
                int nextValue = (Integer)last.getValue();
                if (type > 0) {
                    ++nextValue;
                } else {
                    if (type >= 0) {
                        result = 4;
                        break;
                    }
                    --nextValue;
                }
                boolean bo = this.xMemCacheClient.getMemcachedClient().cas(key, DateUtil.getToTomorrowSeconds(), (Object)nextValue, last.getCas());
                if (bo) {
                    result = 0;
                    break;
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
            result = 5;
        }
        return result;
    }
}

