/**
 * Project Name:activity-center-biz File Name:CategoryActivityBo.java Package
 * Name:cn.com.duiba.activity.center.biz.bo.activity Date:2016年8月25日下午3:34:15 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.bo.activity;

import java.util.*;

import cn.com.duiba.activity.center.api.params.CategoryFloorParams;
import cn.com.duiba.service.exception.BusinessException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerDto;
import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.chaos.ActivityCategorySpecifyService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerService;
import cn.com.duiba.activity.center.biz.service.guess.DuibaGuessService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.activity.center.biz.service.manual.AppManualLotteryService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzService;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.EmbedDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteAppService;

import com.alibaba.fastjson.JSONObject;

/**
 * ClassName:CategoryActivityBo <br/>
 * 关于子页面的各种服务 Date: 2016年8月25日 下午3:34:15 <br/>
 * 
 * @author wubo
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class CategoryActivityBo {

    private static final Logger             log = LoggerFactory.getLogger(CategoryActivityBo.class);
    @Autowired
    private ActivityCategoryService         activityCategoryService;
    @Autowired
    private ActivityCategoryRelationService activityCategoryRelationService;
    @Autowired
    private OperatingActivityService        operatingActivityService;
    @Autowired
    private RemoteItemKeyService            remoteItemKeyService;
    @Autowired
    private DuibaSingleLotteryService       duibaSingleLotteryService;
    @Autowired
    private DuibaHdtoolService              duibaHdtoolService;
    @Autowired
    private DuibaQuizzService               duibaQuizzService;
    @Autowired
    private DuibaQuestionAnswerService      duibaQuestionAnswerService;
    @Autowired
    private DuibaGuessService               duibaGuessService;
    @Autowired
    private DuibaNgameService               duibaNgameService;
    @Autowired
    private SingleLotteryService            singleLotteryService;
    @Autowired
    private AppManualLotteryService         appManualLotteryService;
    @Autowired
    private RemoteAppService                remoteAppService;
    @Autowired
    private ActivityCategorySpecifyService  activityCategorySpecifyService;

    /**
     * 废弃原因:埋点不要放在center工程,当手机端缓存加载出来的内容,就出BUG了
     *         把设置子页面的Id上抬到web,可解决平级系统调用
     * @param appId
     * @param categoryId
     * @param consumerId
     * @param ip
     * @param os
     * @param clickUlr
     * @param start
     * @param pageSize
     * @return
     */
    @Deprecated
    public List<CategoryActivityDto> findAllActivitiesByAppCategory(long appId, long categoryId, long consumerId,
                                                                    String ip, String os, String clickUlr, int start,
                                                                    int pageSize) {
        List<ActivityCategoryRelationEntity> acrs = this.activityCategoryRelationService.findByAppCategory(appId,
                                                                                                           categoryId,
                                                                                                           start,
                                                                                                           pageSize);
        List<CategoryActivityDto> dtos = new ArrayList<CategoryActivityDto>();
        List<CategoryActivityDto> rs = new ArrayList<CategoryActivityDto>();

        Set<Long> operatingActivityIdSet = new HashSet<>();
        // 获取 app 信息
        AppDO app = remoteAppService.find(appId);

        if (acrs != null && acrs.size() > 0) {
            for (ActivityCategoryRelationEntity acr : acrs) {

                CategoryActivityDto dto = new CategoryActivityDto();
                dto.setId(acr.getId());
                dto.setOperatingId(acr.getOperatingActivityId());
                dto.setPayload(acr.getPayload());
                dto.setAppId(appId);
                dto.setCategoryId(categoryId);
                dtos.add(dto);
                operatingActivityIdSet.add(acr.getOperatingActivityId());
            }

            List<OperatingActivityDto> activityDtos = operatingActivityService.findAllByIds(new ArrayList<Long>(
                                                                                                                operatingActivityIdSet));// 批量查询opertingActivity
            Map<Long, OperatingActivityDto> map = new HashMap<>();
            for (OperatingActivityDto activityDto : activityDtos) {
                map.put(activityDto.getId(), activityDto);
            }
            // 获取跳转链接
            for (CategoryActivityDto cat : dtos) {
                OperatingActivityDto activity = map.get(cat.getOperatingId());
                cat.setType(activity.getType());
                cat.setActivityId(activity.getActivityId());
                cat.setTitle(activity.getTitle());
                cat.setBanner(activity.getBannerImage());
                cat.setThumb(activity.getSmallImage());
                cat.setLogo(activity.getLogo());
                if (activity == null || activity.getStatus() != OperatingActivityDto.StatusIntOpen) {
                    // this.remoteActivityCategoryBackendService.removeActivityCategoryRelation(activity.getId());
                    continue;
                }
                JSONObject json = new JSONObject();
                String infoType = this.setImage(cat);
                // 应用id
                json.put("app_id", appId);
                // 用户id
                json.put("consumer_id", consumerId);
                // 登陆状态（未登录：0，登陆：1）
                json.put("login_type", 1);
                // 细节类型
                json.put("info_type", infoType);
                // 细节类型
                json.put("info", activity.getActivityId());
                // ip
                json.put("ip", ip);
                json.put("os", os);
                json.put("domain", clickUlr);
                if (infoType.equals(EmbedDO.InfoType_NGame)) {
                    json.put("activity_type", 9);
                    json.put("duiba_activity_id", activity.getActivityId());
                }
                ItemKey key = remoteItemKeyService.getItemKeyIncludeDeleted(null, activity.getAppItemId(), appId);

                ItemKeyVO itemKeyVo = new ItemKeyVO(key);
                if (activity.getCustomCredits() != null && activity.getCustomCredits() > 0L) {
                    cat.setCredits(activity.getCustomCredits());
                } else {
                    cat.setCredits((long) Math.ceil(activity.getCredits() * (long) app.getCreditsRate() / 100.0));
                }
                cat.setLink(itemKeyVo.getLink());
                cat.setSt_info(json.toJSONString());
                rs.add(cat);
            }
        }
        return rs;
    }

    /**
     * 查询operating活动的各种图片字段 <br/>
     * 不同活动的图片字段存储在不同的表中,根据operatingActivityId,查出type与activityId，然后分别去对应的表中查询此字段<br/>
     * 目前只是活动子页面用到此方法,涉及到部分活动,故只查询了涉及到的活动，不涉及的懒的弄了<br/>
     * 涉及到活动如下：<br/>
     * 兑吧活动 <br/>
     * 活动名称 smallImage字段所在表 <br/>
     * 兑吧单品抽奖 duiba_single_lottery <br/>
     * 兑吧活动工具 duiba_hdtool <br/>
     * 兑吧测试题 duiba_quizz <br/>
     * 兑吧答题 duiba_question_answer <br/>
     * 兑吧竞猜 duiba_guess <br/>
     * 兑吧游戏平台 duiba_ngame <br/>
     * 自有活动 <br/>
     * 自有单品抽奖 app_single_lottery <br/>
     * 老大转盘 operating_activity <br/>
     * 手动开奖 app_manual_lottery <br/>
     * 自有活动工具(摇一摇，刮刮卡，摇奖机) operating_activity<br/>
     *
     * @author wubo
     * @param activity
     * @return
     * @since JDK 1.6
     */
    public String setImage(CategoryActivityDto activity) {
        Integer type = activity.getType();
        Long activityId = activity.getActivityId();
        String infotype = EmbedDO.InfoType_Items;
        if (type == OperatingActivityDto.TypeTurnTable) {
            infotype = EmbedDO.InfoType_Turntable;
        } else if (isAppHdtool(activity)) {
            infotype = EmbedDO.InfoType_AppManualLottery;
        } else if (type == OperatingActivityDto.TypeDuibaSingleLottery) {// 其余活动就 只能一个一个根据type判断类型，然后去对应的表中拿字段
            DuibaSingleLotteryDto entity = this.duibaSingleLotteryService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            // 这b没有推荐图
            infotype = EmbedDO.InfoType_SingleLottery;
        } else if (activity.isHdTool() && activityId != null) {
            DuibaHdtoolDto entity = this.duibaHdtoolService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype = EmbedDO.InfoType_Hdtool;
        } else if (type == OperatingActivityDto.TypeDuibaQuizz) {
            DuibaQuizzDto entity = this.duibaQuizzService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype = EmbedDO.InfoType_Quizz;
        } else if (type == OperatingActivityDto.TypeDuibaQuestionAnswer) {
            DuibaQuestionAnswerDto entity = this.duibaQuestionAnswerService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype = EmbedDO.InfoType_Question;
        } else if (type == OperatingActivityDto.TypeDuibaGuess) {
            DuibaGuessDto entity = this.duibaGuessService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype = EmbedDO.InfoType_Guess;
        } else if (type == OperatingActivityDto.TypeDuibaNgame) {
            DuibaNgameDto entity = this.duibaNgameService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBanner());
            activity.setLogo(entity.getLogo());
            activity.setWhitethumb(entity.getWhiteImage());
            activity.setRecommendImage(entity.getRecommendImage());
            infotype = EmbedDO.InfoType_NGame;
        } else if (type == OperatingActivityDto.TypeAppSingleLottery) {
            AppSingleLotteryDto entity = this.singleLotteryService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
            // activity.setWhitethumb(entity.getWhiteImage());
            // activity.setRecommendImage(entity.getRecommendImage());
            infotype = EmbedDO.InfoType_AppManualLottery;
        } else if (type == OperatingActivityDto.TypeAppManualLottery) {
            AppManualLotteryDto entity = this.appManualLotteryService.find(activityId);
            activity.setThumb(entity.getSmallImage());
            activity.setBanner(entity.getBannerImage());
            activity.setLogo(entity.getLogo());
            // activity.setWhitethumb(entity.getWhiteImage());
            // activity.setRecommendImage(entity.getRecommendImage());
            infotype = EmbedDO.InfoType_AppManualLottery;
        } else {
            // 其余活动暂不考虑
        }
        return infotype;
    }

    /**
     * isAppHdtool:判断是否是自有的活动工具 <br/>
     * 自有活动工具属性信息存储在operatingactivity表中,activityId为null 兑吧活动工具属性信息存储在活动工具表中，operatingactivity.activityId关联活动工具表的id
     *
     * @author wubo
     * @param oa(参数类中必须包含type字段)
     * @return
     * @since JDK 1.6
     */
    public boolean isAppHdtool(CategoryActivityDto oa) {
        boolean rs = false;
        if (oa.isHdTool()) {
            if (oa.getActivityId() == null) {
                rs = true;
            }
        }
        return rs;
    }



    public Boolean isCategoryEnable(Long appId, Long categoryId) {
        ActivityCategoryEntity activityCategory = activityCategoryService.findById(categoryId);
        if(activityCategory == null){
            return false;
        }
        if(activityCategory.getSpecify()){
            //开启定向，判断app是否在定向白名单中
            Set<Long> appIdSet = activityCategorySpecifyService.findAppIdList(categoryId);
            return appIdSet.contains(appId);
        }else{
            return true;
        }
    }

    private static final Integer LoadMax = 16;
    /**
     * 加载子页面楼层数据
     * @param params
     * @return
     */
    public List<CategoryActivityDto> findAppFloorCategory(CategoryFloorParams params) throws BusinessException {
        if(!isCategoryEnable(params.getAppId(),params.getCategoryId())){
            throw new BusinessException("该子页面已经被删除或者已经被定向");
        }
        List<ActivityCategoryRelationEntity> list = activityCategoryRelationService.findByAppCategory(params.getAppId(),params.getCategoryId(),1,LoadMax);
        List<Long> operatingActivityIds = Lists.newArrayList();
        for(ActivityCategoryRelationEntity entity:list){
            operatingActivityIds.add(entity.getOperatingActivityId());
        }
        List<OperatingActivityDto> opList = operatingActivityService.findAllByIds(operatingActivityIds);
        if(opList.isEmpty()){
            return Collections.emptyList();
        }
        Map<Long,OperatingActivityDto> opMap = Maps.newHashMap();
        for(OperatingActivityDto it:opList){
            opMap.put(it.getId(),it);
        }

        List<CategoryActivityDto> returnList = Lists.newArrayList();
        for(ActivityCategoryRelationEntity entity:list){
            if(!opMap.containsKey(entity.getOperatingActivityId())){
                continue;
            }
            OperatingActivityDto op = opMap.get(entity.getOperatingActivityId());
            if(op.getStatus()!=OperatingActivityDto.StatusIntOpen){
                continue;
            }
            CategoryActivityDto dto = new CategoryActivityDto();
            dto.setId(entity.getId());
            dto.setOperatingId(entity.getOperatingActivityId());
            dto.setPayload(entity.getPayload());
            dto.setAppId(params.getAppId());
            dto.setCategoryId(params.getCategoryId());
            dto.setTitle(op.getTitle());
            dto.setType(op.getType());
            dto.setActivityId(op.getActivityId());
            dto.setBanner(op.getBannerImage());
            dto.setThumb(op.getSmallImage());
            dto.setLogo(op.getLogo());
            if(op.getCustomCredits() !=null && op.getCustomCredits() > 0L){
                dto.setCredits(op.getCustomCredits());
            }else{
                dto.setCredits(op.getCredits());
            }
            setImage(dto);//设置非自有活动的图片
            returnList.add(dto);
            if(returnList.size()>=params.getSize()){
                break;
            }
        }
        return returnList;
    }



}
