package cn.com.duiba.activity.center.biz.bo.rob.impl;

import cn.com.duiba.activity.center.api.dto.direct.ActivityBlackList4DeveloperDto;
import cn.com.duiba.activity.center.api.dto.direct.DuibaActivityAppSpecifyNewDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.params.TodayRobFloorParams;
import cn.com.duiba.activity.center.biz.bo.rob.TodayRobFloorBo;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * Created by liuyao on 2016/11/2.
 */
@Service
public class TodayRobFloorBoImpl implements TodayRobFloorBo {
    @Autowired
    private TodayRobConfigService todayRobConfigService;
    @Autowired
    private DeveloperActBlackService developerActBlackService;
    @Autowired
    private DuibaActivityAppSpecifyNewService duibaActivityAppSpecifyNewService;
    /**
     * 应为今日必抢楼层最多只显示8个,在这基础留出黄金分割比0.618的过滤余量 8/0.382
     */
    private static final Integer LoadMax = 21;

    @Override
    public List<TodayRobConfigDto> findFloorTodayRobList(TodayRobFloorParams params) {

        List<TodayRobConfigDto> allList = todayRobConfigService.findSortTodayRobConfig(0,LoadMax);
        //过滤黑名单
        allList = blackFilter(params.getDeveloperId(),allList);
        //过滤定向
        allList = specifyFilter(params.getAppId(),allList);

        if(allList.size()>params.getSize()){
            allList = allList.subList(0,params.getSize());
        }
        return allList;
    }

    private List<TodayRobConfigDto> blackFilter(Long developId,List<TodayRobConfigDto> list){
        List<TodayRobConfigDto> newList = Lists.newArrayList();
        for(TodayRobConfigDto dto:list){
            if(dto.isOpenSwitch(TodayRobConfigDto.SWITCHES_DEV_BLACKLIST)){
                Boolean blackResult = isExistBlackByActivityIdAndActivityTypeAndDeveloperId(dto.getId(), ActivityBlackList4DeveloperDto.TypeDuibaRob,developId);
                if(blackResult){
                    continue;
                }
            }
            newList.add(dto);
        }
        return newList;
    }

    private List<TodayRobConfigDto> specifyFilter(Long appId,List<TodayRobConfigDto> list){
        List<TodayRobConfigDto> newList = Lists.newArrayList();

        List<Long> specifyActivityIds = Lists.newArrayList();
        for(TodayRobConfigDto dto:list){
            if(dto.isOpenSwitch(TodayRobConfigDto.SWITCHES_DIRECT)){//收集定向的活动Id
                specifyActivityIds.add(dto.getId());
            }
        }
        List<Long> tt = duibaActivityAppSpecifyNewService.batchFindIsSpecifyActivityIds(specifyActivityIds,appId,DuibaActivityAppSpecifyNewDto.ACTIVITY_HD_TYPE_ROB);
        //转化成Set提高匹配效率
        Set<Long> activityIds = Sets.newHashSet(tt);
        for(TodayRobConfigDto dto:list){
            if(dto.isOpenSwitch(TodayRobConfigDto.SWITCHES_DIRECT) && !activityIds.contains(dto.getId())){
                continue;
            }else{
                newList.add(dto);
            }
        }
        return newList;
    }

    private Boolean isExistBlackByActivityIdAndActivityTypeAndDeveloperId(Long activityId, Integer activityType, Long developerId) {
        ActivityBlackList4DeveloperDto dto = new ActivityBlackList4DeveloperDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setDeveloperId(developerId);
        Boolean bo = developerActBlackService.getBlackCache(dto);
        if(null == bo){
            Integer result = developerActBlackService.query(dto);
            Boolean bolresult = false;
            if (result > 0) {
                bolresult = true;
            }
            developerActBlackService.setBlackCache(dto, bolresult);
            return bolresult;
        }
        return bo;
    }
}
