package cn.com.duiba.activity.center.biz.bo.stock;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreChangeStockDto;
import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreChangeStockService;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.dcommons.domain.Tuple.Tuple2;
import cn.com.duiba.service.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 管理员后台库存变更明细
 * @author zp
 *
 */
@Service
public class ActStockChangeBo {

	//from ActStockChangeServiceImpl in manager

	private static Logger log = LoggerFactory.getLogger(ActStockChangeBo.class);
	@Resource
	private ActPreStockSerivce actPreStockSerivce;
	@Autowired
	private ActPreChangeStockService actPreChangeStockService;

	@Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
	public Tuple2<Integer, Integer> addActStockQuantity(Long prizeId,String relationType,Long appId,Long quantity) throws BusinessException {

		Tuple2<Integer, Integer> tuple = null;//添加前的库存，添加后的库存
		
		ActPreStockDto preStock = null;
		if(appId.equals(0L)){
			preStock = actPreStockSerivce.findPreStockByShare(prizeId, relationType);
		}else{
			preStock = actPreStockSerivce.findPreStockByApp(prizeId, relationType, appId);
		}
		
		if(null == preStock){
			throw new BusinessException(relationType + "活动：奖项预分配库存不存在");
		}
		Long preStockId = preStock.getId();

		ActPreStockDto preStockLock = actPreStockSerivce.findByLock(preStockId);

		int result = actPreStockSerivce.addRemainingById(preStockId, quantity);
		if(result < 1){
			throw new BusinessException("添加活动预分配奖项库存失败");
		}

		tuple = Tuple.tuple(quantity.intValue(),
				preStockLock.getPrizeQuantity().intValue() + quantity.intValue());

		ActPreChangeStockDto changeStock = new ActPreChangeStockDto(true);
		changeStock.setPreStockId(preStockId);
		changeStock.setRelationPrizeId(prizeId);
		changeStock.setRelationType(relationType);
		changeStock.setChangeQuantity(quantity);
		changeStock.setBeforeStock(preStockLock.getPrizeQuantity());
		changeStock.setAfterStock(preStockLock.getPrizeQuantity() + quantity);
		changeStock.setChangeKind(ActPreChangeStockDto.KIND_ADD);

		actPreChangeStockService.insert(changeStock);

		return tuple;
	}

	@Transactional(value = DsConstants.DATABASE_CREDITS_ACTIVITY)
	public Tuple2<Integer, Integer> reduceActStockQuantity(Long prizeId,String relationType,Long appId,Long quantity) throws BusinessException {
		
		Tuple2<Integer, Integer> tuple = null;//扣除前的库存，扣除后的库存

		ActPreStockDto preStock = null;
		if(appId.equals(0L)){
			preStock = actPreStockSerivce.findPreStockByShare(prizeId, relationType);
		}else{
			preStock = actPreStockSerivce.findPreStockByApp(prizeId, relationType, appId);
		}
		
		if(null == preStock){
			throw new BusinessException(relationType + "活动：奖项预分配库存不存在");
		}
		Long preStockId = preStock.getId();

		ActPreStockDto preStockLock = actPreStockSerivce.findByLock(preStockId);

		if(preStockLock.getPrizeQuantity() <= quantity){
			quantity = preStockLock.getPrizeQuantity();

			tuple = Tuple.tuple(quantity.intValue(), 0);
		}else{
			tuple = Tuple.tuple(quantity.intValue(),
					preStockLock.getPrizeQuantity().intValue() - quantity.intValue());
		}

		int result = actPreStockSerivce.subRemainingById(preStockId, quantity);
		if(result < 1){
			throw new BusinessException("减少活动预分配奖项库存失败");
		}

		ActPreChangeStockDto changeStock = new ActPreChangeStockDto(true);
		changeStock.setPreStockId(preStockId);
		changeStock.setRelationPrizeId(prizeId);
		changeStock.setRelationType(relationType);
		changeStock.setChangeQuantity(quantity);
		changeStock.setBeforeStock(preStockLock.getPrizeQuantity());
		changeStock.setAfterStock(preStockLock.getPrizeQuantity() - quantity);
		changeStock.setChangeKind(ActPreChangeStockDto.KIND_SUB);

		actPreChangeStockService.insert(changeStock);
		return tuple;
	}
	
	public ActPreStockDto findActValidStock(Long relationPrizeId,
											String relationType, Long appId) {
		ActPreStockDto preStock = actPreStockSerivce.findPreStockByApp(relationPrizeId, relationType, appId);
		if(null == preStock){
			preStock = actPreStockSerivce.findPreStockByShare(relationPrizeId, relationType);
		}
		return preStock;
	}

}
