package cn.com.duiba.activity.center.biz.dao.category.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.category.ActivityCategorySpecifyDao;
import cn.com.duiba.activity.center.biz.entity.chaos.ActivityCategorySpecifyEntity;

/**
 * 活动子页面定向
 * Author ：zhengjy <br/>
 * Create Time：2016年9月9日 下午7:25:21 <br/>
 */
@Repository
public class ActivityCategorySpecifyDaoImpl extends ActivityBaseDao  implements ActivityCategorySpecifyDao{
	
	@Override
	public List<ActivityCategorySpecifyEntity> selectSpecifyAll(Long activityCategoryId, Integer pageIndex, Integer pageSize) {
		Map<String,Object> paramMap = Maps.newConcurrentMap();
		paramMap.put("activityCategoryId", activityCategoryId);
		paramMap.put("pageIndex", pageIndex);
		paramMap.put("pageSize", pageSize);
		return  selectList("selectSpecifyAll", paramMap);
	}
	
	@Override
	public Integer selectSpecifyAllCount(Long activityCategoryId,Integer pageIndex,Integer pageSize) {
		Map<String,Object> paramMap = Maps.newConcurrentMap();
		paramMap.put("activityCategoryId", activityCategoryId);
		paramMap.put("pageIndex", pageIndex);
		paramMap.put("pageSize", pageSize);
		return selectOne("selectSpecifyAllCount",activityCategoryId);
	}

	@Override
	public Integer insertSpecify(ActivityCategorySpecifyEntity activityCategorySpecifyEntity) {
		return insert("insertSpecify", activityCategorySpecifyEntity);
	}

	@Override
	public Integer deleteSpecify(Long id) {
		return delete("deleteSpecify", id);
	}
	
	
	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_ACTIVITY;
	}

	@Override
	public List<ActivityCategorySpecifyEntity> selectByAppSpecifys(Long appId) {
		return selectList("selectByAppSpecifys", appId);
	}

	@Override
	public ActivityCategorySpecifyEntity selectById(Long id) {
		return selectOne("selectById",id);
	}

    @Override
    public List<Long> findAppIdList(Long activityCategoryId) {
        return selectList("findAppIdList", activityCategoryId);
    }
}
