package cn.com.duiba.activity.center.biz.dao.chaos.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.chaos.ActPreStockDao;
import cn.com.duiba.activity.center.biz.entity.chaos.ActPreStockEntity;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/22.
 */
@Repository
public class ActPreStockDaoImpl extends ActivityBaseDao implements ActPreStockDao{
    @Override
    public ActPreStockEntity findPreStockByApp(Long relationPrizeId,
                                               String relationType, Long appId) {
        Map<String,Object> param = new HashMap<String,Object>();
        param.put("relationPrizeId", relationPrizeId);
        param.put("relationType", relationType);
        param.put("appId", appId);
        return selectOne("findPreStockByApp", param);
    }
    
    @Override
    public List<ActPreStockEntity> findPreStockListByApp(List<Long> relationPrizeIds, String relationType, Long appId){
    	Map<String,Object> param = new HashMap<String,Object>();
    	param.put("ids", relationPrizeIds);
        param.put("relationType", relationType);
        param.put("appId", appId);
        return selectList("findPreStockListByApp", param);
    }

    @Override
    public ActPreStockEntity findPreStockByShare(Long relationPrizeId,
                                             String relationType) {
        Map<String,Object> param = new HashMap<String,Object>();
        param.put("relationPrizeId", relationPrizeId);
        param.put("relationType", relationType);
        return selectOne("findPreStockByShare", param);
    }

    @Override
    public ActPreStockEntity findByLock(Long id) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        return selectOne("findByLock", param);
    }

    @Override
    public int decrementRemaining(Long id) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        return update("decrementRemaining", param);
    }

    @Override
    public int incrementRemaining(Long id) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        return update("incrementRemaining", param);
    }

    @Override
    public int addRemainingById(Long id, Long addRemaining) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        param.put("addRemaining", addRemaining);
        return update("addRemainingById", param);
    }

    @Override
    public int subRemainingById(Long id, Long subRemaining) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        param.put("subRemaining", subRemaining);
        return update("subRemainingById", param);
    }

    @Override
    public void insert(ActPreStockEntity ActPreStockEntity) {
        insert("insert",ActPreStockEntity);
    }

    @Override
    public int update(ActPreStockEntity ActPreStockEntity) {
        return update("update", ActPreStockEntity);
    }

    @Override
    public int deleteActStock(Long configId, String relationType) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("configId", configId);
        param.put("relationType", relationType);
        return delete("deleteActStock", param);
    }

    @Override
    public int deleteActPrizeStock(Long configId, Long prizeId,
                                   String relationType) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("configId", configId);
        param.put("relationType", relationType);
        param.put("prizeId", prizeId);
        return delete("deleteActPrizeStock", param);
    }

    @Override
    public int deleteActStockAppId(Long prizeId, String relationType, Long appId) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("relationType", relationType);
        param.put("prizeId", prizeId);
        param.put("appId", appId);
        return delete("deleteActStockAppId", param);
    }

    @Override
    public List<ActPreStockEntity> findActStockByConfigId(Long configId,
                                                      String relationType) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("configId", configId);
        param.put("relationType", relationType);
        return selectList("findActStockByConfigId", param);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

    @Override
    public ActPreStockEntity find(Long id) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        return selectOne("find", param);
    }
}
