package cn.com.duiba.activity.center.biz.dao.gamecommon;

import cn.com.duiba.activity.center.biz.entity.common.CustomerGameAppEntity;



/**
 * describe : 游戏记录dao
 * @author  : cdm
 * @date    : 2016年10月13日 下午5:03:10
 */
public interface CustomerGameAppDao{
	
	/**
	 * describe : 根据ID查询实体
	 * @author  : cdm
	 * @date    : 2016年10月19日上午10:55:06
	 * @param id
	 */
	CustomerGameAppEntity selectOneById(Long id);
	
	/**
	 * describe : 根据游戏ID，用户ID，appID查询用户app游戏记录
	 * @author  : cdm
	 * @date    : 2016年10月19日下午2:52:55
	 * @param GameId        游戏ID
	 * @param customerId    用户ID
	 * @param appId         应用ID
	 */
	CustomerGameAppEntity selectByGameIdAndCustomerIdAndappId(Long GameId, Long customerId, Long appId);
    
    /**
     * describe : 增加
     * @author  : cdm
     * @date    : 2016年10月19日上午10:56:15
     * @param entity
     */
    Long insert(CustomerGameAppEntity entity);
    
    /**
     * describe : 根据用户ID，游戏ID，appID更新游戏记录
     * @author  : cdm
     * @date    : 2016年10月19日下午5:32:24
     * @param gameId        游戏ID
     * @param customerId    用户ID
     * @param appId         应用ID
     * @param bestRecord    最佳分
     * @param rank          排名
     */
    int  updateRecod(Long gameId, Long customerId, Long appId,Long bestRecord, Long rank);
    
    /**
     * describe : 根据用户ID，游戏ID，appID更新游戏授权结果
     * @author  : cdm
     * @date    : 2016年10月19日下午5:34:45
     * @param gameId        游戏ID
     * @param customerId    用户ID
     * @param appId         应用ID
     */
    int updateIsBuy(Long gameId, Long customerId, Long appId);
}