package cn.com.duiba.activity.center.biz.dao.littlegame.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.littlegame.LittleGameDao;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;

/**
 * describe : 小游戏dao实现类
 * 
 * @author : cdm
 * @date : 2016年10月13日 下午5:45:05
 */
@Repository
public class LittleGameDaoImpl extends ActivityBaseDao implements LittleGameDao {

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_GAME;
    }

    @Override
    public LittleGameEntity selectById(Long id) {
        return selectOne("selectById", id);
    }

    @Override
    public List<LittleGameEntity> selectList(String title, int offset, int max) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("title", title);
        params.put("offset", offset);
        params.put("max", max);
        return selectList("selectList", params);
    }

    @Override
    public Long selectCount(String title) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("title", title);
        return selectOne("selectCount", params);
    }

    @Override
    public Long insert(LittleGameEntity entity) {
        insert("insert", entity);
        return entity.getId();
    }

    @Override
    public Long update(LittleGameEntity entity) {
        update("update", entity);
        return entity.getId();
    }

    @Override
    public List<LittleGameEntity> selectListByStatus(int status, int offset, int max) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("status", status);
        params.put("offset", offset);
        params.put("max", max);
        return selectList("selectListByStatus", params);
    }

    @Override
    public Integer countByStatus(int status) {
        return selectOne("countByStatus", status);
    }

    @Override
    public int updateCategory(Long id,Long categoryId) {
        Map<String,Object> params = Maps.newHashMap();
        params.put("id", id);
        params.put("littleGameCategoryId", categoryId);
        return update("updateCategory",params);
    }

}
