/**
 * Project Name:activity-center-biz
 * File Name:TodayRobConfigDao.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.rob
 * Date:2016年7月25日下午3:08:49
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
 */

package cn.com.duiba.activity.center.biz.dao.rob;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobActivityDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * ClassName:TodayRobConfigDao <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月25日 下午3:08:49 <br/>
 *
 * @author zp
 * @see
 * @since JDK 1.6
 */
public interface TodayRobConfigDao {

    /**
     * 根据id查询
     *
     * @param configId
     * @return
     * @author zp
     * @since JDK 1.6
     */
    public TodayRobConfigDto find(Long configId);

    /**
     * 新增
     *
     * @param todayRobConfigDto
     * @return
     * @author zp
     * @since JDK 1.6
     */
    public Long insert(TodayRobConfigDto todayRobConfigDto);

    /**
     * 编辑/保存
     *
     * @param todayRobConfigDto
     * @return
     * @author zp
     * @since JDK 1.6
     */
    public Long update(TodayRobConfigDto todayRobConfigDto);

    /**
     * 分页查询
     *
     * @param params
     * @return
     * @author zp
     * @since JDK 1.6
     */
    public List<TodayRobConfigDto> findTodayRobConfigPage(Map<String, Object> params);

    /**
     * 分页count
     *
     * @param params
     * @return
     * @author zp
     * @since JDK 1.6
     */
    public Integer findTodayRobConfigCount(Map<String, Object> params);

    /**
     * 删除活动
     *
     * @param configId
     * @return
     * @author zp
     * @since JDK 1.6
     */
    public Boolean del(Long configId);

    /**
     * 状态改变
     *
     * @param configId
     * @param status
     * @return
     * @author zp
     * @since JDK 1.6
     */
    public Boolean statusChange(Long configId, Integer status);

    /**
     * 排序包括置顶
     *
     * @param offset
     * @param pageSize
     * @return
     * @author zp
     * @since JDK 1.6
     */
    public List<TodayRobConfigDto> findSortTodayRobConfig(Integer offset, Integer pageSize);

    /**
     * 更新置顶
     *
     * @param id
     * @param switches
     * @param stickyTime
     * @return
     * @author zp
     * @since JDK 1.6
     */
    public Boolean updateStickyTime(Long id, Integer switches, Date stickyTime);

    /**
     * 更新参与次数
     *
     * @param id
     * @return
     * @author zp
     * @since JDK 1.6
     */
    public Boolean updateVisitTime(Long id);

    /**
     * 取消全部已经置顶的今日必抢活动
     *
     * @return
     * @author sunchangji
     * @since JDK 1.7
     */
    Boolean updateAllTopSwitches();

    /**
     * 根据活动id集合查询开启且可见的活动
     *
     * @param ids 活动id的集合
     * @return
     */
    List<TodayRobConfigDto> findTodayRobConfigForAppByIds(List<Long> ids);

    /**
     * 根据活动id集合查询开启且可见和关闭且可见的活动
     *
     * @param ids 活动id的集合
     * @return
     */
    List<RobActivityDto> findTodayRobConfigForManagerByIds(List<Long> ids);
}

