/**
 * Project Name:activity-center-biz
 * File Name:TodayRobConfigDaoImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.rob.impl
 * Date:2016年7月25日下午3:09:23
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.rob.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.rob.category.RobActivityDto;
import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobConfigDao;

/**
 * ClassName:TodayRobConfigDaoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月25日 下午3:09:23 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class TodayRobConfigDaoImpl extends ActivityBaseDao implements TodayRobConfigDao{

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

    @Override
    public TodayRobConfigDto find(Long configId){
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("id", configId);
        return selectOne("find",map);
    }

    @Override
    public Long insert(TodayRobConfigDto todayRobConfigDto) {
        insert("insert", todayRobConfigDto);
        return todayRobConfigDto.getId();
    }
    
    @Override
    public Long update(TodayRobConfigDto todayRobConfigDto) {
        update("update", todayRobConfigDto);
        return todayRobConfigDto.getId();
    }

    @Override
    public List<TodayRobConfigDto> findTodayRobConfigPage(Map<String, Object> params) {
        return selectList("findTodayRobConfigPage",params);
    }

    @Override
    public Integer findTodayRobConfigCount(Map<String, Object> params) {
        return selectOne("findTodayRobConfigCount",params);
    }

    @Override
    public Boolean del(Long configId) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("id", configId);
        if(1 == delete("delTodayRobConfig", map)){
            return true;
        }
        return false;
    }

    @Override
    public Boolean statusChange(Long configId, Integer status) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("id", configId);
        map.put("status", status);
        if(1 == update("statusChange",map)){
            return true;
        }
        return false;
    }

    @Override
    public List<TodayRobConfigDto> findSortTodayRobConfig(Integer offset, Integer pageSize) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("offset", offset);
        map.put("pageSize", pageSize);
        return selectList("findSortTodayRobConfig",map);
    }

    @Override
    public Boolean updateStickyTime(Long id, Integer switches, Date stickyTime) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("id", id);
        map.put("switches", switches);
        map.put("stickyTime", stickyTime);
        if(1 == update("updateStickyTime",map)){
            return true;
        }
        return false;
    }

    @Override
    public Boolean updateVisitTime(Long id) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("id", id);
        if(1 == update("updateVisitTime",map)){
            return true;
        }
        return false;
    }

    @Override
    public Boolean updateAllTopSwitches() {
        if(update("updateAllTopSwitches",null)>0){
            return true;
        }
        return false;
    }

    @Override
    public List<TodayRobConfigDto> findTodayRobConfigForAppByIds(List<Long> ids) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("ids",ids);
        return selectList("findTodayRobConfigForAppByIds",map);
    }

    @Override
    public List<RobActivityDto> findTodayRobConfigForManagerByIds(List<Long> ids) {
        Map<String,Object> map = new HashMap<String,Object>();
        map.put("ids",ids);
        return selectList("findTodayRobConfigForManagerByIds",map);
    }

}

