package cn.com.duiba.activity.center.biz.dao.rob_category;

import java.util.List;

/**
 * 描述:今日必抢分类与活动关联表操作dao接口定义
 *
 * @author :sunchangji
 * @create :2016-10-17 13:24
 */
public interface RobCategoryActivityRelationDao {

    /**
     * 根据分类id分页查询该分类下的活动id集合
     *
     * @param categoryId 分类id
     * @param offset     开始条数
     * @param pageSize   页距
     * @return
     */
    List<Long> getPageRobActivityIdsByCategoryId(Long categoryId, int offset, int pageSize);

    /**
     * 根据分类id查询出所有的分类id集合
     *
     * @param categoryId 分类id
     * @return
     */
    List<Long> getAllRobActivityIdsByCategoryId(Long categoryId);

    /**
     * 根据活动查询分类id集合
     *
     * @param activityId
     * @return
     */
    List<Long> getCategoryIdsByActivityId(Long activityId);

    /**
     * 根据分类id查询总条数
     *
     * @param categoryId
     * @return
     */
    int countByCategoryId(Long categoryId);

    /**
     * 根据分类id物理删除
     *
     * @param categoryId 分类id
     * @return
     */
    int deleteByCategoryId(Long categoryId);

    /**
     * 根据活动id物理删除
     *
     * @param activityId 活动id
     * @return
     */
    int deleteByActivityId(Long activityId);

    /**
     * 根据活动id与分类id删除记录
     *
     * @param activityId 活动id
     * @param categoryId 分类id
     * @return
     */
    int deleteByActivityIdAndCategoryId(Long activityId, Long categoryId);

    /**
     * 新增记录
     *
     * @param categoryId 分类id
     * @param activityId 活动id
     * @param payload    排序值
     * @return
     */
    int insertRobCategoryActivityRelation(Long categoryId, Long activityId, Integer payload);

    /**
     * 更新排序值
     *
     * @param categoryId 分类id
     * @param activityId 活动id
     * @param payload    排序值
     * @return
     */
    int updateRobCategoryActivityRelation(Long categoryId, Long activityId, Integer payload);

}
