package cn.com.duiba.activity.center.biz.dao.rob_category;

import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarAppRelationEntity;

import java.util.List;

/**
 * 描述:今日必抢分类栏与应用关联dao操作接口定义
 *
 * @author :sunchangji
 * @create :2016-10-17 13:14
 */
public interface RobCategoryBarAppRelationDao {

    /**
     * 查询全部记录
     *
     * @return
     */
    List<RobCategoryBarAppRelationEntity> getAllList();

    /**
     * 根据appId查询记录
     *
     * @param appId
     * @return
     */
    RobCategoryBarAppRelationEntity getByAppId(Long appId);

    /**
     * 根据分类栏id查询分类栏与应用关联实体
     *
     * @param barId 分类栏id
     * @return
     */
    List<RobCategoryBarAppRelationEntity> getEntityByBarId(Long barId);

    /**
     * 根据分类栏id查询该分类栏下对应的应用id集合
     *
     * @param barId
     * @return
     */
    List<Long> getAppIdsByBarId(Long barId);

    /**
     * 根据分类栏id和应用id查询
     *
     * @param appId
     * @param barId
     * @return
     */
    RobCategoryBarAppRelationEntity getByAppIdAndBarId(Long appId, Long barId);

    /**
     * 新增
     *
     * @return
     */
    int insert(Long appId, String appName, Long barId);

    /**
     * 根据分类栏id删除
     *
     * @param barId
     * @return
     */
    int deleteByBarId(Long barId);

    /**
     * 根据分类栏id批量删除
     *
     * @param barIds 分类栏id集合
     * @return
     */
    int batchDeleteByBarId(List<Long> barIds);

    /**
     * 根据应用id删除
     *
     * @param appId
     * @return
     */
    int deleteByAppId(Long appId);

    /**
     * 应用id和根据分类栏删除操作
     *
     * @param appId 应用id
     * @param barId 分组id
     * @return
     */
    int deleteByAppIdAndBarId(Long appId, Long barId);

    /**
     * 更新操作
     *
     * @param appId
     * @param barId
     * @return
     */
    int updateAppIdAndBarId(Long appId, String appName, Long barId);


}
