package cn.com.duiba.activity.center.biz.dao.rob_category;

import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarEntity;

import java.util.List;

/**
 * 描述:分类栏dao接口定义
 *
 * @author :sunchangji
 * @create :2016-10-17 11:51
 */
public interface RobCategoryBarDao {
    /**
     * 分页查询分类栏，name为空查询全部
     *
     * @param name     分类栏名称
     * @param offset   分页开始位置
     * @param pageSize 每页条数
     * @return
     */
    List<RobCategoryBarEntity> getPageByName(String name, Integer offset, Integer pageSize);

    /**
     * 根据分类栏id集合查询分类栏列表
     *
     * @param barIds 分类栏id集合
     * @return
     */
    List<RobCategoryBarEntity> getByBarIds(List<Long> barIds);

    /**
     * 根据分类栏id
     *
     * @param id 分类栏id
     * @return
     */
    RobCategoryBarEntity getById(Long id);

    /**
     * 根据分类栏名称查询总条数，名称为空查询全部总条数
     *
     * @param name 分类栏名称
     * @return 总条数
     */
    int countByName(String name);

    /**
     * 新增分类栏
     *
     * @return
     */
    Long insertRobCategoryBar(RobCategoryBarEntity robCategoryBarEntity);

    /**
     * 编辑分类栏
     *
     * @param id
     * @param name
     * @return
     */
    int updateRobCategoryBar(Long id, String name);

    /**
     * 物理删除分类栏
     *
     * @param id 分类栏id
     * @return
     */
    int deleteById(Long id);

    /**
     * 获取全部分类栏列表
     *
     * @return
     */
    List<RobCategoryBarEntity> getAllCategoryBarList();

}
