package cn.com.duiba.activity.center.biz.dao.rob_category.impl;

import cn.com.duiba.activity.center.biz.dao.rob_category.RobBarCategoryRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.base.RobCategoryBaseDao;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

/**
 * 描述:今日必抢分类栏与分类关联操作dao实现类
 *
 * @author :sunchangji
 * @create :2016-10-17 13:22
 **/
@Repository("robBarCategoryRelationDao")
public class RobBarCategoryRelationDaoImpl extends RobCategoryBaseDao implements RobBarCategoryRelationDao {


	@Override
	public List<Long> getRobCategoryIdsByBarId(Long barId) {
		return selectList("getRobCategoryIdsByBarId",barId);
	}

	@Override
	public int insertRobBar(Long barId, Long categoryId, int payload) {
		Map<String, Object> queryMap = this.getQueryMap(3);
		queryMap.put("barId",barId);
		queryMap.put("categoryId",categoryId);
		queryMap.put("payload",payload);
		return insert("insertRobBar",queryMap);
	}

	@Override
	public int updateRobBar(Long barId, Long categoryId, int payload) {
		Map<String, Object> queryMap = this.getQueryMap(3);
		queryMap.put("barId",barId);
		queryMap.put("categoryId",categoryId);
		queryMap.put("payload",payload);
		return update("updateRobBar",queryMap);
	}

	@Override
	public int deleteByBarId(Long barId) {
		return delete("deleteByBarId",barId);
	}

    @Override
    public int deleteByCategoryId(Long categoryId) {
        return delete("deleteByCategoryId",categoryId);
    }

    @Override
	public int deleteByBarIdAndCategoryId(Long barId, Long categoryId) {
		Map<String, Object> queryMap = this.getQueryMap(2);
		queryMap.put("barId",barId);
		queryMap.put("categoryId",categoryId);
		return delete("deleteByBarIdAndCategoryId",queryMap);
	}
}
