package cn.com.duiba.activity.center.biz.dao.rob_category.impl;

import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryActivityRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.base.RobCategoryBaseDao;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * 描述:今日必抢分类与活动关联表操作dao实现类
 *
 * @author :sunchangji
 * @create :2016-10-17 13:25
 */
@Repository("robCategoryActivityRelationDao")
public class RobCategoryActivityRelationDaoImpl extends RobCategoryBaseDao implements RobCategoryActivityRelationDao {


    @Override
    public List<Long> getPageRobActivityIdsByCategoryId(Long categoryId, int offset, int pageSize) {
        Map<String, Object> queryMap = this.getQueryMap(3);
        queryMap.put("categoryId", categoryId);
        queryMap.put("offset", offset);
        queryMap.put("pageSize", pageSize);
        return selectList("getPageRobActivityIdsByCategoryId", queryMap);
    }

    @Override
    public List<Long> getAllRobActivityIdsByCategoryId(Long categoryId) {
        return selectList("getAllRobActivityIdsByCategoryId", categoryId);
    }

    @Override
    public List<Long> getCategoryIdsByActivityId(Long activityId) {
        return selectList("getCategoryIdsByActivityId", activityId);
    }

    @Override
    public int countByCategoryId(Long categoryId) {
        return selectOne("countByCategoryId", categoryId);
    }

    @Override
    public int deleteByCategoryId(Long categoryId) {
        return delete("deleteByCategoryId", categoryId);
    }

    @Override
    public int deleteByActivityId(Long activityId) {
        return delete("deleteByActivityId", activityId);
    }

    @Override
    public int deleteByActivityIdAndCategoryId(Long activityId, Long categoryId) {
        Map<String, Object> queryMap = this.getQueryMap(2);
        queryMap.put("categoryId", categoryId);
        queryMap.put("activityId", activityId);
        return delete("deleteByActivityIdAndCategoryId", queryMap);
    }

    @Override
    public int insertRobCategoryActivityRelation(Long categoryId, Long activityId, Integer payload) {
        if (payload == null)
            payload = 0;
        Map<String, Object> queryMap = this.getQueryMap(3);
        queryMap.put("categoryId", categoryId);
        queryMap.put("activityId", activityId);
        queryMap.put("payload", payload);
        return insert("insertRobCategoryActivityRelation", queryMap);
    }

    @Override
    public int updateRobCategoryActivityRelation(Long categoryId, Long activityId, Integer payload) {
        if (payload == null)
            payload = 0;
        Map<String, Object> queryMap = this.getQueryMap(3);
        queryMap.put("categoryId", categoryId);
        queryMap.put("activityId", activityId);
        queryMap.put("payload", payload);
        return update("updateRobCategoryActivityRelation", queryMap);
    }

}
