package cn.com.duiba.activity.center.biz.dao.rob_category.impl;

import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarAppRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.base.RobCategoryBaseDao;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarAppRelationEntity;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * 描述:今日必抢分类栏与应用关联操作dao实现类
 *
 * @author :sunchangji
 * @create :2016-10-17 13:15
 */
@Repository("robCategoryBarAppRelationDao")
public class RobCategoryBarAppRelationDaoImpl extends RobCategoryBaseDao implements RobCategoryBarAppRelationDao {


    @Override
    public List<RobCategoryBarAppRelationEntity> getAllList() {
        return selectList("getAllList");
    }

    @Override
    public RobCategoryBarAppRelationEntity getByAppId(Long appId) {
        return selectOne("getByAppId", appId);
    }

    @Override
    public List<RobCategoryBarAppRelationEntity> getEntityByBarId(Long barId) {
        return selectList("getEntityByBarId", barId);
    }

    @Override
    public List<Long> getAppIdsByBarId(Long barId) {
        return selectList("getAppIdsByBarId", barId);
    }

    @Override
    public RobCategoryBarAppRelationEntity getByAppIdAndBarId(Long appId, Long barId) {
        Map<String, Object> queryMap = this.getQueryMap(2);
        queryMap.put("appId", appId);
        queryMap.put("barId", barId);
        return selectOne("getByAppIdAndBarId", queryMap);
    }

    @Override
    public int insert(Long appId, String appName, Long barId) {
        Map<String, Object> queryMap = this.getQueryMap(3);
        queryMap.put("appId", appId);
        queryMap.put("appName", appName);
        queryMap.put("barId", barId);
        return insert("insert", queryMap);
    }

    @Override
    public int deleteByBarId(Long barId) {
        return delete("deleteByBarId", barId);
    }

    @Override
    public int batchDeleteByBarId(List<Long> barIds) {
        Map<String, Object> queryMap = this.getQueryMap(1);
        queryMap.put("barIds",barIds);
        return delete("batchDeleteByBarId", queryMap);
    }

    @Override
    public int deleteByAppId(Long appId) {
        return delete("deleteByAppId", appId);
    }

    @Override
    public int deleteByAppIdAndBarId(Long appId, Long barId) {
        Map<String, Object> queryMap = this.getQueryMap(2);
        queryMap.put("appId", appId);
        queryMap.put("barId", barId);
        return delete("deleteByAppIdAndBarId", queryMap);
    }

    @Override
    public int updateAppIdAndBarId(Long appId, String appName, Long barId) {
        Map<String, Object> queryMap = this.getQueryMap(3);
        queryMap.put("appId", appId);
        queryMap.put("appName", appName);
        queryMap.put("barId", barId);
        return update("updateAppIdAndBarId", queryMap);
    }

}
