package cn.com.duiba.activity.center.biz.dao.seckill.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.seckill.DuibaSeckillStockConfigLogDao;
import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillStockConfigConsumeEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.Map;

@Repository("duibaSeckillStockConfigLogDao")
public class DuibaSeckillStockConfigLogDaoImpl extends ActivityBaseDao implements DuibaSeckillStockConfigLogDao {

	@Override
	public int insertConsumeLog(DuibaSeckillStockConfigConsumeEntity log) {
		return insert("insertConsumeLog", log);
	}

	@Override
	public DuibaSeckillStockConfigConsumeEntity findByUnique(String action,Integer relationType, Long relationId) {
		Map<String,Object> params = Maps.newHashMap();
		params.put("action", action);
		params.put("relationType", relationType);
		params.put("relationId",relationId);
		return selectOne("findByUnique", params);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.SECKILL;
	}
}
