package cn.com.duiba.activity.center.biz.dao.seconds_kill;

import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import cn.com.duiba.activity.center.biz.dao.readwrite.AbstractReadWaySupport;

public class BaseConsumerDao extends AbstractReadWaySupport {

    @Autowired
    @Qualifier("bizSqlSessionTemplate")
    protected SqlSessionTemplate sqlSession;

    @Autowired
    @Qualifier("bizReadOnlySqlSessionTemplate")
    protected SqlSessionTemplate readOnlySqlSession;

    @Override
    public SqlSessionTemplate getReadWaySqlSession() {
        return readOnlySqlSession;
    }

    @Override
    public SqlSessionTemplate getSelectRouteSqlSession() {
        if (canGoReadWay()) {
            return readOnlySqlSession;
        } else {
            return sqlSession;
        }
    }

    protected String getStamentNameSpace(String method) {
        return getClass().getName() + "." + method;
    }
}
