package cn.com.duiba.activity.center.biz.dao.singlelottery.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.singlelottery.SingleLotteryDao;
import cn.com.duiba.activity.center.biz.entity.singlelottery.AppSingleLotteryEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/20.
 */
/**
 * 单品抽奖业务DAO
 */
@Repository
public class SingleLotteryDaoImpl extends ActivityBaseDao implements SingleLotteryDao {

    //以下方法来自 SingleLotterySimpleDAO

    /**
     * 根据ID查询
     */
    public AppSingleLotteryEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    public AppSingleLotteryEntity findForupdate(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findForupdate", paramMap);
    }

    /**
     * useless
     * 根据ID集合查询开发者单品抽奖
     */
    public List<AppSingleLotteryEntity> findAllByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return selectList("findAllByIds", paramMap);
    }

    //以下方法来自 AppSingleLotteryStatusChangeDAO

    @Override
    public int addMainAppItemRemainingById(Long id, Integer addMainAppItemRemaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("addMainAppItemRemaining", addMainAppItemRemaining);
        return update("addMainAppItemRemainingById", paramMap);
    }

    @Override
    public int subMainAppItemRemainingById(Long id, Integer subMainAppItemRemaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("subMainAppItemRemaining", subMainAppItemRemaining);
        return update("subMainAppItemRemainingById", paramMap);
    }

    @Override
    public Integer findRemaingForupdate(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findRemaingForupdate", paramMap);
    }


    //以下方法来自SingleLotteryTextChangeDAO


    /**
     * useless
     * 新增开发者单品抽奖
     */
    public void insert(AppSingleLotteryEntity appSingleLotteryDO) {
        insert("insert", appSingleLotteryDO);
    }

    /**
     * useless
     * 根据ID修改
     */
    public int update(AppSingleLotteryEntity appSingleLotteryDO) {
        return update("update", appSingleLotteryDO);
    }

    /**
     * 减主奖品剩余个数
     */
    public int reduceMainAppItemRemaining(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("reduceMainAppItemRemaining", paramMap);
    }

    /**
     * 加主奖品剩余个数
     */
    public int addMainAppItemRemaining(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("addMainAppItemRemaining", paramMap);
    }

    /**
     * useless
     * 开发者后台更新
     */
    public int updateForDevEdit(AppSingleLotteryEntity appSingleLottery) {
        return update("updateForDevEdit", appSingleLottery);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}
