package cn.com.duiba.activity.center.biz.entity.hdtool;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;

import java.io.Serializable;
import java.util.Date;

/**
 * 兑吧活动工具
 * 
 * @author houwen
 */
public class DuibaHdtoolEntity implements Serializable {
	private static final long serialVersionUID = -1692595446834739092L;

	private Long id;
	private String title;
	private Integer type;
	private String subType;
	private Integer creditsType;
	private Long creditsPrice;
	private Integer freeLimit;
	private String freeScope;
	private Integer limitCount;
	private String limitScope;
	private String description;
	private String image;
	private String bannerImage;
	private String smallImage;
	private String whiteImage;
	private String logo;
	private Integer switches;
	private Integer status;
	private Boolean deleted;
	private Date gmtCreate;
	private Date gmtModified;

	private String rateIntroduction;	// 概率说明
	private Date autoOffDate; //定时自动下架日期
	private String recommendImage; // 推荐位横幅图
	private String freeRule;
	private Long activityCategoryId;//活动分类
	private String tag;
	private Byte activityActionType;//普通活动：0；商业化活动：1
	
	public DuibaHdtoolEntity() {

	}

	public DuibaHdtoolEntity(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public DuibaHdtoolEntity(boolean init4insert) {
		if (init4insert) {
			status = OperatingActivityDto.StatusIntNoComplete;
			deleted = false;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}
	
	public String getTag() {
        return tag;
    }
    
    public void setTag(String tag) {
        this.tag = tag;
    }
	
	public void openSwitch(int s) {
		int v = 1 << s;
		switches = switches | v;
	}

	public void closeSwitch(int s) {
		int v = 1 << s;
		v = ~v;
		switches = switches & v;
	}

	public boolean isOpenSwitch(int s) {
		int v = 1 << s;
		int ret = switches & v;
		return ret != 0;
	}

	public String getRateIntroduction() {
		return rateIntroduction;
	}

	public void setRateIntroduction(String rateIntroduction) {
		this.rateIntroduction = rateIntroduction;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getSubType() {
		return subType;
	}

	public void setSubType(String subType) {
		this.subType = subType;
	}

	public Integer getCreditsType() {
		return creditsType;
	}

	public void setCreditsType(Integer creditsType) {
		this.creditsType = creditsType;
	}

	public Long getCreditsPrice() {
		return creditsPrice;
	}

	public void setCreditsPrice(Long creditsPrice) {
		this.creditsPrice = creditsPrice;
	}

	public Integer getFreeLimit() {
		return freeLimit;
	}

	public void setFreeLimit(Integer freeLimit) {
		this.freeLimit = freeLimit;
	}

	public String getFreeScope() {
		return freeScope;
	}

	public void setFreeScope(String freeScope) {
		this.freeScope = freeScope;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public String getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(String limitScope) {
		this.limitScope = limitScope;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public Integer getSwitches() {
		return switches;
	}

	public void setSwitches(Integer switches) {
		this.switches = switches;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public String getRecommendImage() {
		return recommendImage;
	}

	public void setRecommendImage(String recommendImage) {
		this.recommendImage = recommendImage;
	}

	public String getFreeRule() {
		return freeRule;
	}

	public void setFreeRule(String freeRule) {
		this.freeRule = freeRule;
	}

    public Long getActivityCategoryId() {
        return activityCategoryId;
    }
    
    public void setActivityCategoryId(Long activityCategoryId) {
        this.activityCategoryId = activityCategoryId;
    }
    
    public Byte getActivityActionType() {
        return activityActionType;
    }
    
    public void setActivityActionType(Byte activityActionType) {
        this.activityActionType = activityActionType;
    }
	
}
