/**
 * Project Name:activity-center-biz
 * File Name:AdActivityMQSend.java
 * Package Name:cn.com.duiba.activity.center.biz.kafka
 * Date:2016年10月19日下午4:18:04
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.kafka;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

/**
 * ClassName:AdActivityMQSend <br/>
 * 商业类型的活动增删改时，发消息同步给广告系统
 * 目前支持商业类型的活动：新活动工具
 * 
 * Date:     2016年10月19日 下午4:18:04 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class AdActivityMQSend {
    
    private static Logger  log = LoggerFactory.getLogger(AdActivityMQSend.class);
    
    @Resource
    private MessageService messageService;
    
    @Resource
    private TopicConstant topicConstant;
    
    public void adActivityInsertSync(Long activityId,Integer activityType,String activityName,Integer activityStatus,String tag){
        adActivitySendDataSync(this.generatorMessage(activityId, activityType, activityName, activityStatus, tag, AdActivityMessage.Action_Insert_Type));
    }
    
    public void adActivityUpdateSync(Long activityId,Integer activityType,String activityName,Integer activityStatus,String tag){
        adActivitySendDataSync(this.generatorMessage(activityId, activityType, activityName, activityStatus, tag, AdActivityMessage.Action_Update_Type));
    }
    
    public void adActivityDeleteSync(Long activityId,Integer activityType){
        adActivitySendDataSync(this.generatorMessage(activityId, activityType,null,null,null, AdActivityMessage.Action_Delete_Type));
    }
    
    private AdActivityMessage generatorMessage(Long activityId,Integer activityType,String activityName,Integer activityStatus,String tag,String actionType){
        AdActivityMessage message = new AdActivityMessage();
        message.setActivityId(activityId);
        message.setActivityType(activityType);
        message.setActivityName(activityName);
        message.setActivityStatus(activityStatus);
        message.setTag(tag);
        message.setAction(actionType);
        return message;
    }
    
    public void adActivitySendDataSync(AdActivityMessage message){
        try {
            {
                messageService.sendMsg(topicConstant.getTopicAdActivitySync(), message);
            }
        } catch (Exception e) {
            log.error("adActivity send message is error,"+ message.toString() , e);
        }
    }
}

