/**
 * Project Name:activity-center-biz
 * File Name:AdActivityMessage.java
 * Package Name:cn.com.duiba.activity.center.biz.kafka
 * Date:2016年10月19日下午4:22:26
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.kafka;

/**
 * ClassName:AdActivityMessage <br/>
 * Date:     2016年10月19日 下午4:22:26 <br/>
 * Attention:消息会格式成json格式发送给广告平台，如果添加或删除参数的话，对方解析会报错，so，别乱动
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class AdActivityMessage implements Message{
    public static final String Action_Insert_Type = "insert";
    public static final String Action_Delete_Type = "delete";
    public static final String Action_Update_Type = "update";
    
    private Long activityId;            //活动id
    private Integer activityType;       //活动类型 OperatingActivityDto定义
    private String activityName;        //活动标题
    private Integer activityStatus;     //活动状态
    private String tag;                 //活动标签
    private String action;              //操作行为，上面常量定义
    
    public Long getActivityId() {
        return activityId;
    }
    
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }
    
    public Integer getActivityType() {
        return activityType;
    }
    
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }
    
    public String getActivityName() {
        return activityName;
    }
    
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }
    
    public Integer getActivityStatus() {
        return activityStatus;
    }
    
    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }
    
    public String getTag() {
        return tag;
    }
    
    public void setTag(String tag) {
        this.tag = tag;
    }
    
    public String getAction() {
        return action;
    }
    
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public int getMaxBodyBytes() {
        return 2048;
    }

    @Override
    public String toString() {
        return "AdActivityMessage [activityId=" + activityId + ", activityType=" + activityType + ", activityName="
               + activityName + ", activityStatus=" + activityStatus + ", tag=" + tag + ", action=" + action + "]";
    }
    
    
}

