package cn.com.duiba.activity.center.biz.plugin.buckle.impl;

import java.util.Date;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;

import cn.com.duiba.activity.center.api.dto.other.NotifyQueueDO;
import cn.com.duiba.activity.center.biz.constant.Environment;
import cn.com.duiba.activity.center.biz.dao.other.DuibaRemainingMoneyDAO;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.activity.center.biz.kafka.MessageService;
import cn.com.duiba.activity.center.biz.kafka.TopicConstant;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsCallback;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCutCreditsService;
import cn.com.duiba.activity.center.biz.plugin.buckle.LittleGameConsumerCreditsCallback;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent.ActivityOrdersEventType;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.activity.center.biz.service.gamecommon.CustomerGameAppService;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.activity.center.biz.tools.AssembleTool;
import cn.com.duiba.activity.center.biz.tools.service.ActualPriceCalService;
import cn.com.duiba.activity.center.biz.tools.service.FrequentExchangeLimitService;
import cn.com.duiba.activity.center.biz.tools.service.ItemKeyStockServcie;
import cn.com.duiba.activity.center.biz.tools.service.TimeLimitService;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.dcommons.flowwork.ActivityLotteryFlowworkService;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * describe : 单纯扣积分业务逻辑
 * @author  : cdm
 * @date    : 2016年10月20日 下午6:34:06
 */
@Service
public class ConsumerCutCreditsServiceImpl implements ConsumerCutCreditsService{

    private static Logger log = LoggerFactory.getLogger(ConsumerCutCreditsServiceImpl.class);
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private LittleGameConsumerCreditsCallback littleGameConsumerCreditsCallback;
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private TimeLimitService timeLimitService;
    @Autowired
    private ItemKeyStockServcie itemKeyStockServcie;
    @Autowired
    private RemoteAddrLimitService remoteAddrLimitService;
    @Autowired
    private ActualPriceCalService actualPriceCalService;
    @Autowired
    private DuibaRemainingMoneyDAO duibaRemainingMoneyDAO;
    @Autowired
    private FrequentExchangeLimitService frequentExchangeLimit;
    @Autowired @Qualifier("notifyQueueDAO")
    private NotifyQueueDAOImpl notifyQueueDAO;
    @Autowired
    private NotifyCenterServiceClient notifyCenterServiceClient;
    @Autowired
    private ActivityLotteryFlowworkService activityLotteryFlowworkService;
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;
    @Autowired
   	private CustomerGameAppService customerGameAppService;
    
    /**
     * describe : 消耗积分
     * @author : cdm
     * @date :2016年10月20日 下午4:43:15
     */
    @Override
    public void asyncConsumerCredits(Long consumerId,String orderNum,String transer,String ip,String description){
        
        DubboResult<ActivityOrderDto> order = remoteActivityOrderService.findByOrderNum(orderNum);
        if(!order.isSuccess() || order.getResult() == null){
        	 CreditsCallbackMessage message = new CreditsCallbackMessage();
             message.setAppId(order.getResult().getAppId().toString());
             message.setRelationId(order.getResult().getOrderNum());
             message.setRelationType(order.getResult().getActivityType());
             Map<String,String> params = Maps.newHashMap();
             params.put("ip", ip);
             message.setParams(params);
             onCreditsFail(message,new Exception("订单号不存在"));
            return;
        }
        //判断订单是否为扣积分状态
        if(order.getResult().getConsumeCreditsStatus() != ActivityOrderDto.ConsumeCreditsProcessing){
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(order.getResult().getAppId().toString());
            message.setRelationId(order.getResult().getOrderNum());
            message.setRelationType(order.getResult().getActivityType());
            Map<String,String> params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams(params);
            onCreditsSuccess(message);
            return;
        }
        //若积分为0
        if(order.getResult().getConsumeCredits() <= 0){
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(order.getResult().getAppId().toString());
            message.setRelationId(order.getResult().getOrderNum());
            message.setRelationType(order.getResult().getActivityType());
            Map<String,String> params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams(params);
            onCreditsSuccess(message);
            return;
        }
        ConsumerDO consumer = remoteConsumerService.find(consumerId);
        AppDO app = remoteAppService.find(consumer.getAppId());
        CreditConsumeParams p = new CreditConsumeParams();
        p.setAppKey(app.getAppKey());
        p.setCredits(order.getResult().getConsumeCredits());
        p.setOrderNum("activity-" + order.getResult().getOrderNum());
        p.setUid(consumer.getPartnerUserId());
        p.setTimestamp(new Date());
        p.setType(order.getResult().getActivityType());
        p.setIp(order.getResult().getIp());
        p.setFacePrice(0);
        p.setActualPrice(0);
        p.setDescription(description);
        if(StringUtils.isNotBlank(transer)){
            p.setTransfer(transer);
        }
        Map<String,String> map = p.toRequestMap(app.getAppSecret());
        
        CreditsMessage mq = new CreditsMessage();
        mq.setTimestamp(System.currentTimeMillis());
        mq.setAppId(order.getResult().getAppId().toString());
        mq.setConsumerId(order.getResult().getConsumerId().toString());
        mq.setRelationId(order.getResult().getOrderNum());
        mq.setRelationType(CreditsMessage.TYPE_LITTLE_GAME);
        Map<String,String> params = Maps.newHashMap();
        params.put("ip", ip);
        mq.setParams(params);
        // 如果是百度云环境，使用post方式
        if (Environment.PlaceBaiduyun.equals(Environment.getPlace())) {
            mq.setHttpUrl(app.getCreditsConsumeRequestUrl());
            mq.setHttpType(CreditsMessage.HTTP_POST);
            mq.setAuthParams(map);
        } else {
            String url = AssembleTool.assembleUrl(app.getCreditsConsumeRequestUrl(), map);
            mq.setHttpUrl(url);
            mq.setHttpType(CreditsMessage.HTTP_GET);
        }
        String str = JSONObject.toJSONString(mq);
        try{
            log.error("->>发送kafka扣积分信息," + str);
            messageService.sendMsg(topicConstant.getTopicConsumerCredits(),str,2000);//"creditsRequestDevABC",str,2000);//topicConstant.getTopicConsumerCredits(),str,2000);
        }catch(Exception e){
        	  CreditsCallbackMessage message = new CreditsCallbackMessage();
              message.setAppId(order.getResult().getAppId().toString());
              message.setRelationId(order.getResult().getOrderNum());
              message.setRelationType(order.getResult().getActivityType());
              Map<String,String> paramss = Maps.newHashMap();
              paramss.put("ip", ip);
              message.setParams(paramss);
              onCreditsFail(message,e);
            return;
        }
    }
    
    @Override
    public void onCreditsFail(CreditsCallbackMessage message,Exception exception){
        ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
        try {
            ActivityOrderDto o4u = new ActivityOrderDto();
            if ((exception instanceof DeveloperConsumeFailedException) && ((DeveloperConsumeFailedException) exception).getNormalFail()) {
                o4u.setError4admin("扣积分失败，开发者返回扣积分失败。" + exception.getMessage());
                o4u.setError4developer("扣积分失败，开发者返回扣积分失败。");
                o4u.setError4consumer("抽奖失败，请稍后再试。");
            } else {
                o4u.setError4admin("扣积分失败，开发者服务器异常。" + exception.getMessage());
                o4u.setError4developer("扣积分失败，" + exception.getMessage());
                o4u.setError4consumer("抽奖失败，请稍后再试。");
            }
            remoteActivityOrderService.consumeCreditsFail(order.getOrderNum(),null, null, 
                                                          null, null, null, null, null, null, null,
                                                          o4u.getError4admin(),o4u.getError4developer(),o4u.getError4consumer());
            if(null!= order){
	            // 返还本地积分
	            if (order.getConsumeCredits() > 0) {
	                remoteConsumerService.increaseCredits(order.getConsumerId(), order.getConsumeCredits());
	            }
            }
        } catch (Exception e) {
            log.error("小游戏扣积分异常:", e);
        } finally {
            complete(message.getRelationId());
            // 发出扣积分失败事件
            DuibaEventsDispatcher.get().dispatchConsumeCreditsFailEvent(new ConsumeCreditsFailEvent(order, new Exception("扣积分失败")));
        }
    }
    
    @Override
    public void onCreditsSuccess(CreditsCallbackMessage message){
    	 
        ActivityOrderDto orderNew = remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
        try{
        	  remoteActivityOrderService.consumeCreditsSuccess(message.getRelationId(),null,null, null,null,null,null,null,null,null);
        	  //小游戏类型更新购买记录
        	  if(ActivityOrderDto.TypeLittleGame.equals(orderNew.getActivityType()) ){
        		  customerGameAppService.updateIsBuy(orderNew.getDuibaActivityId(), orderNew.getConsumerId(), orderNew.getAppId());
        	  }
        }catch (Exception e) {
            log.error("更新扣积分订单状态异常:", e);
        }finally{
            this.complete(message.getRelationId());
            // 发出扣积分成功事件
            DuibaEventsDispatcher.get().dispatchConsumeCreditsSuccessEvent(new ConsumerCreditsSuccessEvent(orderNew));
        }
    }
    
    public void complete(String orderNum) {
        // 查询最新订单信息
        ActivityOrderDto order = remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        // 通知开发者
        insertHdtoolOrderNotifyQueueIfNesscery(order);
        // 发出活动订单事件
        if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsSuccess) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderSuccess, order));
        } else if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsFail) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEventType.OnOrderFail, order));
        }
    }
    
    
    private void insertHdtoolOrderNotifyQueueIfNesscery(ActivityOrderDto order) {
        try {
            if (order.getConsumeCredits() <= 0) {
                return;
            }
            if (order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsProcessing) {
                return;
            }
            ConsumerDO consumer=remoteConsumerService.find(order.getConsumerId());
            
            NotifyQueueDO nq=new NotifyQueueDO();
            nq.setAppId(order.getAppId());
            nq.setConsumerId(order.getConsumerId());
            nq.setDeveloperBizId(order.getDeveloperBizId());
            nq.setDuibaOrderNum("activity-" + order.getOrderNum());
            if (order.getError4developer() != null) {
                nq.setError4developer(order.getError4developer());
            }
            nq.setNextTime(new Date());
            nq.setPartnerUserId(consumer.getPartnerUserId());
            nq.setRelationId(order.getDuibaActivityId());
            nq.setRelationType(NotifyQueueDO.RTActivityRob);
            nq.setTimes(0);
            nq.setResult(order.getConsumeCreditsStatus() == ActivityOrderDto.ConsumeCreditsSuccess);
            notifyQueueDAO.insert(nq);
            notifyCenterServiceClient.notifyImmediately(nq.getId());
        } catch (Exception e) {
            log.error("insertHdtoolOrderNotifyQueueIfNesscery error",e);
        }
    }
    
    
    @Override
    public void creditsCallback(CreditsCallbackMessage message){
        if(null == message || StringUtils.isBlank(message.getRelationId())){
            return;
        }
        DubboResult<ActivityOrderDto> orderResult = remoteActivityOrderService.findByOrderNum(message.getRelationId());
        if(!orderResult.isSuccess() || orderResult.getResult() == null){
            return;
        }
        ActivityOrderDto order = orderResult.getResult();
        if(order.getConsumeCreditsStatus() != ActivityOrderDto.ConsumeCreditsProcessing){
            return;
        }
        if (CreditsCallbackMessage.CALLBACK_TYPE_COMPLETED.equals(message.getCallbackType())) {
        	littleGameConsumerCreditsCallback.completed(message);
        } else if (CreditsCallbackMessage.CALLBACK_TYPE_FAILED.equals(message.getCallbackType())) {
        	littleGameConsumerCreditsCallback.failed(message);
        } else if (CreditsCallbackMessage.CALLBACK_TYPE_CANCELLED.equals(message.getCallbackType())) {
        	littleGameConsumerCreditsCallback.cancelled(message);
        }
    }

}

