package cn.com.duiba.activity.center.biz.remoteservice.impl.activity_brick;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.remoteservice.activity_brick.RemotePopupActivityBrickBackendService;
import cn.com.duiba.activity.center.biz.service.activity_brick.PopupActivityBrickService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemotePopupActivityBrickBackendServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月12日 下午3:04:55 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class RemotePopupActivityBrickBackendServiceImpl implements
		RemotePopupActivityBrickBackendService {

	@Resource
	private PopupActivityBrickService popupActivityBrickService;
	
	@Override
	public DubboResult<PopupActivityBrickDto> insert(PopupActivityBrickDto brick) {
		return DubboResult.successResult(popupActivityBrickService.insert(brick));
	}

	@Override
	public DubboResult<Integer> update(PopupActivityBrickDto brick) {
		return DubboResult.successResult(popupActivityBrickService.update(brick));
	}

	@Override
	public DubboResult<PopupActivityBrickDto> findById(Long id) {
		return DubboResult.successResult(popupActivityBrickService.findById(id));
	}

	@Override
	public DubboResult<Integer> deleteById(Long id) {
		return DubboResult.successResult(popupActivityBrickService.deleteById(id));
	}

	@Override
	public DubboResult<Integer> showBrick(Long id) {
		return DubboResult.successResult(popupActivityBrickService.showBrick(id));
	}

	@Override
	public DubboResult<Integer> hiddenBrick(Long id) {
		return DubboResult.successResult(popupActivityBrickService.hiddenBrick(id));
	}

	@Override
	public DubboResult<List<PopupActivityBrickDto>> findPage(Integer type, Integer offset, Integer max) {
		Map<String, Object> paramMap =new HashMap<String, Object>();
		if (offset != null){
			paramMap.put("offset", offset);
		}
		if (max != null){
			paramMap.put("max", max);
		}
		paramMap.put("type", type);
		return DubboResult.successResult(popupActivityBrickService.findPage(paramMap));
	}

	@Override
	public DubboResult<Long> findPageCount(Integer type) {
		Map<String, Object> paramMap =new HashMap<String, Object>();
		paramMap.put("type", type);
		return DubboResult.successResult(popupActivityBrickService.findPageCount(paramMap));
	}

	@Override
	public DubboResult<List<PopupActivityBrickDto>> findAll(Integer type) {
		Map<String, Object> paramMap =new HashMap<String, Object>();
		paramMap.put("status", 1);
		paramMap.put("type", type);
		return DubboResult.successResult(popupActivityBrickService.findPage(paramMap));
	}

	@Override
	public DubboResult<PopupActivityBrickDto> findByName(Integer type, String name) {
		return DubboResult.successResult(popupActivityBrickService.findByName(type, name));
	}

    @Override
    public DubboResult<List<PopupActivityBrickDto>> findByCondition(Long appId, String name, Integer offset, Integer max) {
        return DubboResult.successResult(popupActivityBrickService.findByCondition(appId, name, offset, max));
    }

    @Override
    public DubboResult<Long> findByConditionCount(Long appId, String name) {
        return DubboResult.successResult(popupActivityBrickService.findByConditionCount(appId, name));
    }

    @Override
    public DubboResult<Integer> updateLayoutBrickPosition(Long id, Integer position) {
        return DubboResult.successResult(popupActivityBrickService.updateLayoutBrickPosition(id, position));
    }
}
