/**
 * Project Name:activity-center-biz
 * File Name:RemoteAdActivityServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl.advert
 * Date:2016年10月10日下午5:08:17
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl.advert;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.advertising.AdActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.advertising.RemoteAdActivityService;
import cn.com.duiba.activity.center.biz.bo.activity.ActivityBo;
import cn.com.duiba.activity.center.biz.constant.DomainConfigureConstant;
import cn.com.duiba.activity.center.biz.constant.MemcachedSpace;
import cn.com.duiba.activity.center.biz.entity.advert.DuibaAdMaterialEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.advert.DuibaAdMaterialService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAdActivityServiceImpl <br/>
 * Date:     2016年10月10日 下午5:08:17 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class RemoteAdActivityServiceImpl implements RemoteAdActivityService{
    
    @Resource
    private DuibaAdMaterialService duibaAdMaterialService;
    @Resource
    private DuibaHdtoolService duibaHdtoolService;
    @Resource
    private OperatingActivityService operatingActivityService;
    @Resource
    private ActivityBo activityBo;
    @Resource
    private RemoteAppService remoteAppService;
    @Resource
    private CacheClient cacheClient;
    private static final Logger    log = LoggerFactory.getLogger(RemoteAdActivityServiceImpl.class);
    @Override
    public DubboResult<AdActivityDto> queryByActivityId(Long activityId, Integer activityType) {
        try{
            AdActivityDto rs;
            
            rs = this.cacheClient.get(this.keyGeneratorForQuery(activityId, activityType));
            
            if(rs==null){
                rs = new AdActivityDto();
                rs.setActivityId(activityId);
                rs.setActivityType(activityType);
                //查询物料信息
                DuibaAdMaterialEntity m = this.duibaAdMaterialService.findByActivity(activityId, activityType);
                if(m!=null){
                    rs.setAdMaterialImg(m.getAdMaterialImg());
                    rs.setAdMaterialTitle(m.getAdMaterialTitle());
                    rs.setAdDescribe(m.getAdDescribe());
                }
                else{
                    rs = null;
                }
                this.cacheClient.set(this.keyGeneratorForQuery(activityId, activityType), rs, 100);
            }

            return DubboResult.successResult(rs);
        } catch (Exception e){
            log.error("RemoteAdActivityService.queryByActivityId("+activityId+","+activityType+")",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<AdActivityDto> addOnApp(Long activityId, Integer activityType, String appKey) {//此接口 除了上架活动，同时也会返回活动url，消费方上架只需要一次，但活动url需要频繁查询，因此做了缓存
        try{
            AdActivityDto dto;
            
            dto = this.cacheClient.get(this.keyGeneratorForAdd(activityId, activityType, appKey));
            if(dto==null){
                dto= new AdActivityDto();
                dto.setActivityId(activityId);
                dto.setActivityType(activityType);
                AppDO app = this.remoteAppService.findByAppKey(appKey);
                if(app==null){
                    throw new Exception("appKey is not exist!");
                }
                Long operatingId = this.activityBo.addActivity(activityId, activityType, app.getId());
                dto.setOperatingActivityId(operatingId);
                //  免登录url
                String url = getUrl(activityType,operatingId,appKey);
                dto.setActivityUrl(url);
                
                this.cacheClient.set(this.keyGeneratorForAdd(activityId, activityType, appKey), dto, 100);
            }
            return DubboResult.successResult(dto);
        } catch (Exception e){
            log.error("RemoteAdActivityService.addOnApp() error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
    /*
     * 生成新活动工具的各种链接
     */
    private String getUrl(Integer activityType,Long operatingId,String appKey) throws Exception{
        String url;
        if (OperatingActivityDto.TypeShakeLottery == activityType) {
            url = getHdtoolUrl(OperatingActivityDto.TypeShakeLottery_Action,operatingId,appKey);
        } else if (OperatingActivityDto.TypeScratchCard == activityType) {
            url = getHdtoolUrl(OperatingActivityDto.TypeScratchCard_Action,operatingId,appKey);
        } else if (OperatingActivityDto.TypeHdToolTiger == activityType) {
            url = getHdtoolUrl(OperatingActivityDto.TypeHdToolTiger_Action,operatingId,appKey);
        } else if (OperatingActivityDto.TypeHdToolTurntable == activityType) {
            url = getHdtoolUrl(OperatingActivityDto.TypeHdToolTurntable_Action,operatingId,appKey);
        } else if (OperatingActivityDto.TypeHdToolFlop == activityType) {
            url = getHdtoolUrl(OperatingActivityDto.TypeHdToolFlop_Action,operatingId,appKey);
        } else if (OperatingActivityDto.TypeHdToolSmashg == activityType) {
            url = getHdtoolUrl(OperatingActivityDto.TypeHdToolSmashg_Action,operatingId,appKey);
        } else {
            throw new Exception("activityType not defined");
        }
        return url;
    }
    private String getHdtoolUrl(String action,Long operatingId,String appKey){
        String url =DomainConfigureConstant.getAppDuibaCreditsDomainName()+"/activity/acShareIndex?url=/"+action+"/index/"+operatingId+"&apk="+appKey;
        return url;
    }
    private String keyGeneratorForQuery(Long activityId, Integer activityType){
        return MemcachedSpace.MS_ADACTIVITY_QUERY+activityId+"-"+activityType;
    }
    private String keyGeneratorForAdd(Long activityId, Integer activityType, String appKey){
        return MemcachedSpace.MS_ADACTIVITY_ADD+activityId+"-"+activityType+"-"+appKey;
    }
    
    
}

