/**
 * Project Name:activity-center-biz File Name:RemoteAdMaterialServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.remoteservice.impl.advert Date:2016年10月10日上午10:56:57 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.remoteservice.impl.advert;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;

import cn.com.duiba.activity.center.api.dto.advertising.DuibaAdMaterialDto;
import cn.com.duiba.activity.center.api.remoteservice.advertising.RemoteAdMaterialService;
import cn.com.duiba.activity.center.biz.entity.advert.DuibaAdMaterialEntity;
import cn.com.duiba.activity.center.biz.service.advert.DuibaAdMaterialService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * ClassName:RemoteAdMaterialServiceImpl <br/>
 * Date: 2016年10月10日 上午10:56:57 <br/>
 * 
 * @author wubo
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class RemoteAdMaterialServiceImpl implements RemoteAdMaterialService {

    private static final Logger    log = LoggerFactory.getLogger(RemoteAdMaterialServiceImpl.class);

    @Resource
    private DuibaAdMaterialService duibaAdMaterialService;

    @Override
    public DubboResult<DuibaAdMaterialDto> queryById(long materialId) {
        try {
            DuibaAdMaterialDto rs;
            DuibaAdMaterialEntity entity = this.duibaAdMaterialService.find(materialId);
            if (entity != null) {
                rs = new DuibaAdMaterialDto();
                ObjectUtil.convert(entity, rs);
            } else {
                rs = null;
            }
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteAdMaterialService.queryById(" + materialId + ") error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<DuibaAdMaterialDto>> queryByIds(List<Long> ids) {
        try {
            List<DuibaAdMaterialDto> rs;
            if(CollectionUtils.isEmpty(ids)){
                rs = null;
            }else{
                List<DuibaAdMaterialEntity> entities = this.duibaAdMaterialService.findByIds(ids);
                if(CollectionUtils.isEmpty(entities)){
                    rs = null;
                } else {
                    rs = Lists.newArrayList();
                    ObjectUtil.convertList(entities, rs, DuibaAdMaterialDto.class);
                }
            }
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteAdMaterialService.queryByIds("+ids.toString()+") error",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<DuibaAdMaterialDto> add(DuibaAdMaterialDto dto) {
        try {
            Preconditions.checkNotNull(dto);
            DuibaAdMaterialEntity entity = new DuibaAdMaterialEntity();
            ObjectUtil.convert(dto, entity);
            Long id = this.duibaAdMaterialService.add(entity);
            if (id != null) {
                dto.setId(id);
            } else {
                throw new Exception("duibaAdMaterialService.add error");
            }
            return DubboResult.successResult(dto);
        } catch (Exception e) {
            log.error("RemoteAdMaterialService.add() error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> update(DuibaAdMaterialDto dto) {
        try {
            Preconditions.checkNotNull(dto, "dto is null!");
            Preconditions.checkNotNull(dto.getId(), "id is null!");
            DuibaAdMaterialEntity entity = new DuibaAdMaterialEntity();
            ObjectUtil.convert(dto, entity);
            boolean rs = this.duibaAdMaterialService.update(entity);
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteAdMaterialService.update() error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> deleteById(long materialId) {
        try {
            boolean rs = this.duibaAdMaterialService.delete(materialId);
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteAdMaterialService.delete(" + materialId + ") error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<DuibaAdMaterialDto> queryByActivity(Long activityId, Integer activityType) {
        try {
            DuibaAdMaterialDto rs;
            DuibaAdMaterialEntity entity = this.duibaAdMaterialService.findByActivity(activityId, activityType);
            if (entity != null) {
                rs = new DuibaAdMaterialDto();
                ObjectUtil.convert(entity, rs);
            } else {
                rs = null;
            }
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteAdMaterialService.queryByActivity(" + activityId+","+activityType + ") error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}
