/**
 * Project Name:activity-center-biz File Name:RemoteCreditGameSkinService.java Package
 * Name:cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame Date:2016年9月10日下午4:46:30 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame;

import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.google.common.base.Preconditions;
import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameSkinDto;
import cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteCreditGameSkinService;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameSkinEntity;
import cn.com.duiba.activity.center.biz.service.creditgame.CreditGameSkinService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;

/**
 * ClassName:RemoteCreditGameSkinService <br/>
 * Function: 积分游戏皮肤接口. <br/>
 * Date: 2016年9月10日 下午4:46:30 <br/>
 * 
 * @author wubo
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class RemoteCreditGameSkinServiceImpl implements RemoteCreditGameSkinService {

    @Resource
    CreditGameSkinService creditGameSkinService;

    private static Logger log = LoggerFactory.getLogger(RemoteCreditGameSkinServiceImpl.class);

    @Override
    public DubboResult<CreditGameSkinDto> find(Long id) {
        CreditGameSkinDto rs;
        try {
            CreditGameSkinEntity entity = this.creditGameSkinService.queryById(id);
            if (entity == null) {
                rs = null;
            } else {
                rs = new CreditGameSkinDto();
                ObjectUtil.convert(entity, rs);
            }
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteCreditGameSkinService.find(" + id + ")", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> add(CreditGameSkinDto dto) {
        try {
            Preconditions.checkNotNull(dto, "RemoteCreditGameSkinService.add(CreditGameSkinDto dto) error,dto is null");
            CreditGameSkinEntity entity = new CreditGameSkinEntity();
            ObjectUtil.convert(dto, entity);
            this.creditGameSkinService.insert(entity);
            return DubboResult.successResult(Boolean.TRUE);
        } catch (Exception e) {
            log.error("RemoteCreditGameSkinService.add() error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Boolean> edit(CreditGameSkinDto dto) {
        try {
            Preconditions.checkNotNull(dto, "RemoteCreditGameSkinService.edit(CreditGameSkinDto dto) error,dto is null");
            Preconditions.checkNotNull(dto.getId(), "id is null");
            CreditGameSkinEntity entity = new CreditGameSkinEntity();
            ObjectUtil.convert(dto, entity);
            this.creditGameSkinService.update(entity);
            return DubboResult.successResult(Boolean.TRUE);
        } catch (Exception e) {
            log.error("RemoteCreditGameSkinService.edit() error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<CreditGameSkinDto> findByActivityId(Long activityId) {
        CreditGameSkinDto rs;
        try {
            Preconditions.checkNotNull(activityId, "activityId is null");
            CreditGameSkinEntity entity = this.creditGameSkinService.queryByCreditGameId(activityId);
            if (entity != null) {
                rs = new CreditGameSkinDto();
                ObjectUtil.convert(entity, rs);
            } else {
                rs = null;
            }
            return DubboResult.successResult(rs);
        } catch (Exception e) {
            log.error("RemoteCreditGameSkinService.findByActivityId(" + activityId + ")", e);
            return DubboResult.failResult(e.getMessage());
        }
    }

}
