package cn.com.duiba.activity.center.biz.remoteservice.impl.game;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerAppSpecifyDto;
import cn.com.duiba.activity.center.api.remoteservice.game.RemoteDuibaQuestionAnswerAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerAppSpecifyService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/5/24.
 */
@Service
public class RemoteDuibaQuestionAnswerAppSpecifyServiceImpl implements RemoteDuibaQuestionAnswerAppSpecifyService {
    @Resource
    private DuibaQuestionAnswerAppSpecifyService duibaQuestionAnswerAppSpecifyService;

    @Override
    public DuibaQuestionAnswerAppSpecifyDto findByQuestionAnswerIdAndAppId(Long questionId, Long appId) {
        return duibaQuestionAnswerAppSpecifyService.findByQuestionAnswerIdAndAppId(questionId, appId);
    }

    public Map<Long, DuibaQuestionAnswerAppSpecifyDto> findByQuestionAnswerIdsAndAppId(List<Long> questionIds, Long appId){
        return duibaQuestionAnswerAppSpecifyService.findByQuestionAnswerIdsAndAppId(questionIds, appId);
    }

    @Override
    public List<DuibaQuestionAnswerAppSpecifyDto> findByDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
        return duibaQuestionAnswerAppSpecifyService.findByDuibaQuestionAnswerId(duibaQuestionAnswerId);
    }

    @Override
    public void delete(Long id) {
        duibaQuestionAnswerAppSpecifyService.delete(id);
    }

    @Override
    public void insert(DuibaQuestionAnswerAppSpecifyDto duibaQuestionAnswerAppSpecify) {
        duibaQuestionAnswerAppSpecifyService.insert(duibaQuestionAnswerAppSpecify);
    }

    @Override
    public DuibaQuestionAnswerAppSpecifyDto find(Long id) {
        return duibaQuestionAnswerAppSpecifyService.find(id);
    }
}
