/**
 * Project Name:activity-center-biz File Name:RemoteGameCenterServiceImpl.java Package
 * Name:cn.com.duiba.activity.center.biz.remoteservice.impl.gamecenter Date:2016年10月21日下午1:48:26 Copyright (c) 2016,
 * duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.remoteservice.impl.gamecenter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceListDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.LittleGameResourceListDto;
import cn.com.duiba.activity.center.api.remoteservice.gamecenter.RemoteGameCenterService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterHomeService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterResourceService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteGameCenterServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月21日 下午1:48:26 <br/>
 * 
 * @author Zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
@Service("remoteGameCenterService")
public class RemoteGameCenterServiceImpl implements RemoteGameCenterService {

    private static final Logger       log = LoggerFactory.getLogger(RemoteGameCenterServiceImpl.class);

    @Autowired
    private GameCenterHomeService     gameCenterHomeService;
    @Autowired
    private GameCenterResourceService gameCenterResourceService;

    @Override
    public DubboResult<GameCenterHomeResourceListDto> findResourceByLocationAndAppId(String locationName, Long appId,
                                                                                     Integer offset, Integer max) {
        try {
            GameCenterHomeResourceListDto gameCenterHomeResourceListDto = gameCenterHomeService.findResourceByLocationAndAppId(locationName,
                                                                                                                               appId,
                                                                                                                               offset,
                                                                                                                               max);
            return DubboResult.successResult(gameCenterHomeResourceListDto);
        } catch (Exception e) {
            log.error("findResourceByLocationAndAppId failed. locationName={}, appId={}, offset={}, max={}",
                      locationName, appId, offset, max, e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<LittleGameResourceListDto> findGameForHomeFloor(Long appId, Integer offset, Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = gameCenterResourceService.findAvailableLittleGameByAppId(appId,
                                                                                                                       offset,
                                                                                                                       max);
        return DubboResult.successResult(littleGameResourceListDto);
    }
}
