package cn.com.duiba.activity.center.biz.remoteservice.impl.gamecommon;


import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.alibaba.dubbo.common.utils.StringUtils;
import cn.com.duiba.activity.center.api.dto.common.CustomerGameAppDto;
import cn.com.duiba.activity.center.api.remoteservice.gamecommon.RemoteCustomerGameAppService;
import cn.com.duiba.activity.center.biz.entity.common.CustomerGameAppEntity;
import cn.com.duiba.activity.center.biz.service.gamecommon.CustomerGameAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * describe : 中奖service 
 * @author  : cdm
 * @date    : 2016年9月27日 下午2:13:05
 */
@Service
public class RemoteCustomerGameAppServiceImpl implements RemoteCustomerGameAppService{
	
	 private static Logger log = LoggerFactory.getLogger(RemoteCustomerGameAppServiceImpl.class);
	
	@Autowired
    private CustomerGameAppService customerGameAppService;
  
	@Override
	public DubboResult<CustomerGameAppDto> getDtoByGameIdAndCustomerId(Long gameId, Long customerId, Long appId,Long gameType) {
		try{
			//查询小游戏实体
			CustomerGameAppEntity customerGameAppEntity = customerGameAppService.selectByGameIdAndCustomerIdAndappId(gameId, customerId, appId);
			Long Id = null;
	    	if(null == customerGameAppEntity || StringUtils.isBlank(String.valueOf(customerGameAppEntity.getId()))){//没有记录，先插入后返回
	    		customerGameAppEntity = new CustomerGameAppEntity();
	    		customerGameAppEntity.setAppId(appId);
	    		customerGameAppEntity.setCustomerId(customerId);
	    		customerGameAppEntity.setGameId(gameId);
	    		customerGameAppEntity.setBestRecord(0L);
	    		customerGameAppEntity.setIsBuy(false);
	    		customerGameAppEntity.setRank(0L);
	    		customerGameAppEntity.setShareNum(0);
	    		customerGameAppEntity.setGameType(gameType);
	    		Id = customerGameAppService.insert(customerGameAppEntity);
	    	}
	    	//复制实体到dto
    		CustomerGameAppDto customerGameAppDto = new CustomerGameAppDto();
        	PropertyUtils.copyProperties(customerGameAppDto, customerGameAppEntity);
        	customerGameAppDto.setId(Id);
        	return DubboResult.successResult(customerGameAppDto);
		}catch(Exception e){
			log.error("查询小游戏记录出现异常==gameId=="+gameId+"===customerId===="+customerId+"=====appId====="+appId, e);
    		return DubboResult.failResult(e.getMessage());
    	}
	}

	@Override
	public DubboResult<Boolean> updateRecod(Long gameId, Long customerId,Long appId, Long bestRecord, Long rank) {
		try{
			customerGameAppService.updateRecod(gameId, customerId, appId, bestRecord, rank);
			return DubboResult.successResult(Boolean.TRUE);
		}catch(Exception e){
			log.error("更新小游戏记录出现异常==gameId=="+gameId+"===customerId===="+customerId+"=====appId====="+appId, e);
    		return DubboResult.failResult(e.getMessage());
    	}
	}

	@Override
	public DubboResult<Boolean> updateIsBuy(Long gameId, Long customerId,Long appId) {
		try{
			customerGameAppService.updateIsBuy(gameId, customerId, appId);
			return DubboResult.successResult(Boolean.TRUE);
		}catch(Exception e){
			log.error("更新小游戏购买==gameId=="+gameId+"===customerId===="+customerId+"=====appId====="+appId, e);
    		return DubboResult.failResult(e.getMessage());
    	}
	}


    
    
    
}

