package cn.com.duiba.activity.center.biz.remoteservice.impl.plugin;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.remoteservice.plugin.RemoteActivityPluginBackendService;
import cn.com.duiba.activity.center.biz.service.plugin.ActivityPluginService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemoteActivityPluginBackendServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月11日 下午3:53:59 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 * @return  
 */
@Service
public class RemoteActivityPluginBackendServiceImpl implements RemoteActivityPluginBackendService {

	@Resource
	private ActivityPluginService activityPluginService;

	@Override
	public DubboResult<ActivityPluginDto> createActivityPluginInfo( ActivityPluginDto activityPluginDto) {
		return DubboResult.successResult(activityPluginService.createActivityPluginInfo(activityPluginDto));
	}

	@Override
	public DubboResult<Integer> updateActivityPluginInfo( ActivityPluginDto activityPluginDto) {
		return DubboResult.successResult(activityPluginService.updateActivityPluginInfo(activityPluginDto));
	}

	@Override
	public DubboResult<ActivityPluginDto> findById(Long id) {
		return DubboResult.successResult(activityPluginService.findById(id));
	}

	@Override
	public DubboResult<Integer> updateStatus(Long id,Integer value) {
		return DubboResult.successResult(activityPluginService.OpenStatus(id,value));
	}

	@Override
	public DubboResult<List<ActivityPluginDto>> findActivityPluginInfoList(Long id,String title,Integer offset, Integer max) {
		Map<String, Object> paramMap =new HashMap<String, Object>();
		if (id != null){
			paramMap.put("id", id);
		}
		if (title != null){
			paramMap.put("title", title);
		}
		if (offset != null){
			paramMap.put("offset", offset);
		}
		if (max != null){
			paramMap.put("max", max);
		}
		return DubboResult.successResult(activityPluginService.findActivityPluginInfoList(paramMap));
	}

	@Override
	public DubboResult<Long> findPageCount(Long id,String title,Integer offset, Integer max) {
		Map<String, Object> paramMap =new HashMap<String, Object>();
		if (id != null){
			paramMap.put("id", id);
		}
		if (title != null){
			paramMap.put("title", title);
		}
		if (offset != null){
			paramMap.put("offset", offset);
		}
		if (max != null){
			paramMap.put("max", max);
		}
		return DubboResult.successResult(activityPluginService.findPageCount(paramMap));
	}

	@Override
	public DubboResult<Integer> dellActivityPlugin(Long id) {
		return DubboResult.successResult(activityPluginService.dellActivityPlugin(id));
	}

    @Override
    public DubboResult<Integer> updateAutoOffDateNull(Date autoOffDate, Long id) {
        return DubboResult.successResult(activityPluginService.updateAutoOffDateNull(autoOffDate, id));
    }
}
