package cn.com.duiba.activity.center.biz.remoteservice.impl.plugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import net.rubyeye.xmemcached.GetsResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.activity_brick.PopupActivityBrickDto;
import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.remoteservice.plugin.RemoteActivityPluginService;
import cn.com.duiba.activity.center.biz.service.activity_brick.PopupActivityBrickService;
import cn.com.duiba.activity.center.biz.service.plugin.ActivityPluginService;
import cn.com.duiba.activity.center.biz.tools.XMemCacheClient;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.wolf.dubbo.DubboResult;

/** 
 * ClassName:RemoteActivityPluginServiceImpl.java <br/>
 * @author  gey 
 * @date 创建时间：2016年10月13日 下午4:36:19 
 * @version 1.0 
 * @parameter  
 * @since   JDK 1.6
 */
@Service
public class RemoteActivityPluginServiceImpl implements
		RemoteActivityPluginService {
	private static Logger log = LoggerFactory.getLogger(RemoteActivityPluginServiceImpl.class);
	@Resource
	private ActivityPluginService activityPluginService;
	@Resource
	private PopupActivityBrickService popupActivityBrickService;
	@Autowired
	private XMemCacheClient xMemCacheClient;
	
	@Override
	public DubboResult<List<ActivityPluginDto>> findActivityPluginInfoList() {
		//查询所有开启
		String key = "ACTIVITY_PLUGIN_TIME_60";
		List<ActivityPluginDto>  dto ;
		try {
			GetsResponse<List<ActivityPluginDto>> last = xMemCacheClient.getMemcachedClient().gets(key);
			if(last == null){
				Map<String, Object> paramMap =new HashMap<String, Object>();
				paramMap.put("status", ActivityPluginDto.STATUS_OPEN);
				dto = activityPluginService.findActivityPluginInfoList(paramMap);
				//设置1分钟缓存
				xMemCacheClient.getMemcachedClient().add(key, 60, dto);
			}else{
				dto = last.getValue();
			}
		} catch (Exception e) {
			log.error("xMemCacheClient 中获取 插件活动信息失败  降级为从 数据库中获取数据",e);
			Map<String, Object> paramMap =new HashMap<String, Object>();
			paramMap.put("status", ActivityPluginDto.STATUS_OPEN);
			dto = activityPluginService.findActivityPluginInfoList(paramMap);
		}
		
		return DubboResult.successResult(dto);
	}

	@Override
	public DubboResult<PopupActivityBrickDto> findBrickById(Long id) {
		return DubboResult.successResult(popupActivityBrickService.findById(id));
	}

	@Override
	public DubboResult<ActivityPluginDto> findById(Long id) {
		return DubboResult.successResult(activityPluginService.findById(id));
	}

	@Override
	public DubboResult<String> createOrder(Long consumerId, String transfer,
			String ip, String description, String ua, String os,
			ActivityPluginDto pluDto) {
		//产生订单号
		try{
			String orderNum = activityPluginService.createOrder(consumerId,transfer,ip,description,ua,os,pluDto);
			return DubboResult.successResult(orderNum);
		}catch (Exception e){
			log.error("订单生成失败",e);
			if(e instanceof StatusException){
				return DubboResult.failResult(((StatusException)e).getMessage());
			}else{
				return DubboResult.failResult(e.getMessage());
			}
		}
	}

	@Override
	public DubboResult<Integer> updateStatus(Long id, Integer value) {
		return DubboResult.successResult(activityPluginService.OpenStatus(id,value));
	}

}
