package cn.com.duiba.activity.center.biz.remoteservice.impl.rob.category;

import cn.com.duiba.activity.center.api.dto.rob.category.RobBarCategoryRelationDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryBarDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.category.RemoteRobCategoryBarService;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarEntity;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryEntity;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryBarService;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 功能描述:今日必抢分类栏service实现类
 *
 * @author sunchangji
 * @date 2016/10/18
 */
@Service
public class RemoteRobCategoryBarServiceImpl implements RemoteRobCategoryBarService {

    @Autowired
    private RobCategoryBarService robCategoryBarService;

    @Autowired
    private RobCategoryService robCategoryService;

    @Override
    public DubboResult<List<RobCategoryBarDto>> getPagByName(String name, Integer offset, Integer pageSize) {
        List<RobCategoryBarEntity> robCategoryBarEntityList = robCategoryBarService.getPagByName(name, offset, pageSize);
        return DubboResult.successResult(robCategoryBarEntityToDtoList(robCategoryBarEntityList));
    }

    @Override
    public DubboResult<Integer> countByName(String name) {
        return DubboResult.successResult(robCategoryBarService.countByName(name));
    }


    @Override
    public DubboResult<Boolean> deleteBarById(Long barId) {
        return DubboResult.successResult(robCategoryBarService.deleteBarById(barId));
    }

    @Override
    public DubboResult<Boolean> insertRobCategoryBar(String name, List<RobBarCategoryRelationDto> relationDtos) {
        if(!CollectionUtils.isEmpty(relationDtos)){
            for(RobBarCategoryRelationDto relationDto : relationDtos){
                RobCategoryEntity robCategoryEntity = robCategoryService.getCategoryById(relationDto.getCategoryId());
                if(robCategoryEntity==null)
                  return DubboResult.failResult("分类id="+relationDto.getCategoryId()+"的分类不存在");
            }
        }
        return DubboResult.successResult(robCategoryBarService.insertRobCategoryBar(name, relationDtos));
    }

    @Override
    public DubboResult<RobCategoryBarDto> getRobCategoryBarById(Long barId) {
        RobCategoryBarEntity robCategoryBarEntity = robCategoryBarService.getRobCategoryBarById(barId);
        if (robCategoryBarEntity == null)
            return DubboResult.failResult("分类栏不存在");
        return DubboResult.successResult(robCategoryBarEntityToDto(robCategoryBarEntity));
    }

    public DubboResult<List<Long>> getRobCategoryIdsBarById(Long barId) {
        return DubboResult.successResult(robCategoryBarService.getRobCategoryIdsBarById(barId));
    }

    @Override
    public DubboResult<List<RobCategoryBarDto>> getAllCategoryBarList() {
        List<RobCategoryBarEntity> robCategoryBarEntityList = robCategoryBarService.getAllCategoryBarList();
        return DubboResult.successResult(robCategoryBarEntityToDtoList(robCategoryBarEntityList));
    }

    @Override
    public DubboResult<Boolean> updateCategoryBar(Long barId, String name, List<RobBarCategoryRelationDto> relationDtos) {
        return DubboResult.successResult(robCategoryBarService.updateCategoryBar(barId,name,relationDtos));
    }

    /**
     * 把RobCategoryBarEntity集合转成RobCategoryBarDto集合
     *
     * @param robCategoryBarEntityList
     * @return
     */
    private List<RobCategoryBarDto> robCategoryBarEntityToDtoList(List<RobCategoryBarEntity> robCategoryBarEntityList) {
        List<RobCategoryBarDto> robCategoryBarDtoList = new ArrayList<>();
        if (CollectionUtils.isEmpty(robCategoryBarEntityList))
            return robCategoryBarDtoList;
        for (RobCategoryBarEntity entity : robCategoryBarEntityList) {
            robCategoryBarDtoList.add(robCategoryBarEntityToDto(entity));
        }
        return robCategoryBarDtoList;
    }

    /**
     * 把RobCategoryBarEntity转成RobCategoryBarDto
     *
     * @param robCategoryBarEntity
     * @return
     */
    private RobCategoryBarDto robCategoryBarEntityToDto(RobCategoryBarEntity robCategoryBarEntity) {
        return new RobCategoryBarDto(robCategoryBarEntity.getId(), robCategoryBarEntity.getName());
    }
}
