package cn.com.duiba.activity.center.biz.remoteservice.impl.seckill;

import cn.com.duiba.activity.center.api.dto.seckill.SeckillStockDto;
import cn.com.duiba.activity.center.api.remoteservice.seckill.RemoteSeckillService;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillService;
import cn.com.duiba.activity.center.biz.service.seckill.impl.SeckillServiceImpl;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("remoteSeckillService")
public class RemoteSeckillServiceImpl implements RemoteSeckillService {

    private static Logger LOGGER = LoggerFactory.getLogger(SeckillServiceImpl.class);

    @Autowired
    private SeckillService seckillService;

    @Override
    public DubboResult<List<SeckillStockDto>> batchGetStock(Long appId, List<Long> duibaSeckillIds) {
        try {
            List<SeckillStockDto> result = seckillService.batchGetStock(appId, duibaSeckillIds);
            return DubboResult.successResult(result);
        } catch (Exception e) {
            LOGGER.error("batchGetStock error", e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
