package cn.com.duiba.activity.center.biz.service.activity.Impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityOptionsDao;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityOptionsEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityOptionsService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Preconditions;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * Created by yansen on 16/6/12.
 */
@Service
public class OperatingActivityOptionsServiceImpl implements OperatingActivityOptionsService {
    @Resource
    private OperatingActivityOptionsDao operatingActivityOptionsDao;


    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return CacheConstants.KEY_OPERATING_ACTIVITY_OPTIONS_BY_ID + id;
    }
    private String getCacheKeyByOperatingActivityId(Long operatingActivityId) {
        return CacheConstants.KEY_OPERATING_ACTIVITY_OPTIONS_BY_OPERATING_ACTIVITY_ID + operatingActivityId;
    }

    @Override
    public OperatingActivityOptionsDto findOptionById(final Long id) {
        return cacheClient.getWithCacheLoader(getCacheKeyById(id), 5, TimeUnit.MINUTES, new CacheLoader<OperatingActivityOptionsDto>() {
            @Override
            public OperatingActivityOptionsDto load() {
                return BeanUtils.copy(operatingActivityOptionsDao.findOptionById(id),OperatingActivityOptionsDto.class);
            }
        });
    }

    @Override
    public List<OperatingActivityOptionsDto> findByOperatingActivityId(final Long operatingActivityId) {
        return cacheClient.getWithCacheLoader(getCacheKeyByOperatingActivityId(operatingActivityId), 1, TimeUnit.HOURS, new CacheLoader<List<OperatingActivityOptionsDto>>() {
            @Override
            public List<OperatingActivityOptionsDto> load() {
                List<OperatingActivityOptionsEntity> entities=operatingActivityOptionsDao.findByOperatingActivityId(operatingActivityId);
                if(CollectionUtils.isEmpty(entities)){
                    return Collections.emptyList();
                }
                List<OperatingActivityOptionsDto> dtoList=new ArrayList<>(entities.size());
                for(OperatingActivityOptionsEntity entity:entities){
                    dtoList.add(copyEntity(entity));
                }
                return dtoList;
            }
        });
    }

    @Override
    public Integer countByOperatingActivityId(Long operatingActivityId) {
        return operatingActivityOptionsDao.countByOperatingActivityId(operatingActivityId);
    }

    @Override
    public int decrementOptionRemaining(Long optionId) {
        OperatingActivityOptionsDto dto = this.findOptionById(optionId);
        if(dto != null) {
            int result = operatingActivityOptionsDao.decrementOptionRemaining(optionId);
            cacheClient.remove(getCacheKeyById(optionId));
            cacheClient.remove(getCacheKeyByOperatingActivityId(dto.getOperatingActivityId()));

            return result;
        }
        return 0;
    }

    @Override
    public int incrementOptionRemaining(Long optionId) {
        OperatingActivityOptionsDto dto = this.findOptionById(optionId);
        if(dto != null) {
            int result= operatingActivityOptionsDao.incrementOptionRemaining(optionId);
            cacheClient.remove(getCacheKeyById(optionId));
            cacheClient.remove(getCacheKeyByOperatingActivityId(dto.getOperatingActivityId()));

            return result;
        }
        return 0;
    }

    @Override
    public int updateOptionDeleteStatus(List<Long> oaoList) {
        if(oaoList == null || oaoList.isEmpty()){
            return 0;
        }
        Set<Long> operatingActivityIds = new HashSet<>();
        for(Long id : oaoList){
            OperatingActivityOptionsDto dto = this.findOptionById(id);
            if(dto != null){
                operatingActivityIds.add(dto.getOperatingActivityId());
            }
        }
        int result =operatingActivityOptionsDao.updateOptionDeleteStatus(oaoList);
        for(Long id:oaoList){
            cacheClient.remove(getCacheKeyById(id));
        }
        for(Long operatingActivityId : operatingActivityIds){
            cacheClient.remove(getCacheKeyByOperatingActivityId(operatingActivityId));
        }
        return result;
    }

    @Override
    public int updatePrize(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull(operatingActivityOptionsDto);

        int result = operatingActivityOptionsDao.updatePrize(copyDto(operatingActivityOptionsDto));
        if(result > 0) {
            removeCacheById(operatingActivityOptionsDto.getId());
        }
        return result;
    }

    @Override
    public void insertOption(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull(operatingActivityOptionsDto);
        OperatingActivityOptionsEntity entity=new OperatingActivityOptionsEntity(true);
        BeanUtils.copy(operatingActivityOptionsDto,entity);
        operatingActivityOptionsDao.insertOption(entity);
        cacheClient.remove(getCacheKeyByOperatingActivityId(entity.getOperatingActivityId()));
        operatingActivityOptionsDto.setId(entity.getId());
    }

    @Override
    public int updateOption(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull(operatingActivityOptionsDto);

        OperatingActivityOptionsEntity entity=new OperatingActivityOptionsEntity(operatingActivityOptionsDto.getId());
        BeanUtils.copy(operatingActivityOptionsDto,entity);
        int result= operatingActivityOptionsDao.updateOption(entity);
        if(result > 0) {
            removeCacheById(operatingActivityOptionsDto.getId());
        }
        return result;
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public OperatingActivityOptionsDto findForupdate(Long id) {
        OperatingActivityOptionsEntity entity= operatingActivityOptionsDao.findForupdate(id);
        return copyEntity(entity);
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        int result= operatingActivityOptionsDao.addRemainingById(id, addRemaining);
        if(result > 0) {
            removeCacheById(id);
        }
        return result;
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        int result= operatingActivityOptionsDao.subRemainingById(id, subRemaining);
        if(result > 0) {
            removeCacheById(id);
        }
        return result;
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        int result= operatingActivityOptionsDao.updateRemainingById(id, remaining);
        if(result > 0) {
            removeCacheById(id);
        }
        return result;
    }

    private void removeCacheById(Long optionId){
        cacheClient.remove(getCacheKeyById(optionId));
        OperatingActivityOptionsDto dto = this.findOptionById(optionId);
        if (dto != null) {
            cacheClient.remove(getCacheKeyByOperatingActivityId(dto.getOperatingActivityId()));
        }
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public Integer findRemaingForupdate(Long id) {
        return operatingActivityOptionsDao.findRemaingForupdate(id);
    }

    private OperatingActivityOptionsDto copyEntity(OperatingActivityOptionsEntity entity){
        if (entity == null) {
            return null;
        }
        OperatingActivityOptionsDto dto = new OperatingActivityOptionsDto();
        BeanUtils.copy(entity, dto);
        return dto;
    }

    private OperatingActivityOptionsEntity copyDto(OperatingActivityOptionsDto dto){
        if(dto==null){
            return null;
        }
        OperatingActivityOptionsEntity entity=new OperatingActivityOptionsEntity();
        BeanUtils.copy(dto,entity);
        return entity;
    }
}
