package cn.com.duiba.activity.center.biz.service.elasticgifts.impl;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppListDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppSaveResultDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsCommonAppEnum;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsAppDao;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsDao;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsAppEntity;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsEntity;
import cn.com.duiba.activity.center.biz.remoteservice.impl.seconds_kill.RemoteSeckillAppOrderServiceImpl;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsAppService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service("elasticGiftsAppService")
public class ElasticGiftsAppServiceImpl implements ElasticGiftsAppService {

    private static       Logger     LOGGER          = LoggerFactory.getLogger(RemoteSeckillAppOrderServiceImpl.class);
    public static final List<Long> APP_COMMON_LIST = Collections.singletonList(0L);

    @Autowired
    private ElasticGiftsAppDao elasticGiftsAppDao;
    @Autowired
    private ElasticGiftsDao    elasticGiftsDao;
    @Autowired
    private RemoteAppService   remoteAppService;

    @Override
    public List<ElasticGiftsAppListDto> getAllElasticGiftsApps(ElasticGiftsBizCodeEnum bizCode, Long activityId) {
        Preconditions.checkNotNull(bizCode, "业务编号不能为 null");
        List<ElasticGiftsAppEntity> entities = elasticGiftsAppDao.findAllByBizCodeAndElId(bizCode.value(), activityId);
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }
        Multimap<Long, ElasticGiftsAppEntity> multimap = ArrayListMultimap.create();
        ElasticGiftsAppEntity common = null;
        for (ElasticGiftsAppEntity it : entities) {
            if (it.getAppId() == ElasticGiftsCommonAppEnum.COMMON.value()) {
                common = it;
                continue;
            }
            multimap.put(it.getElasticGiftsId(), it);
        }
        List<ElasticGiftsAppListDto> result = new ArrayList<>();

        // 共享库第一个
        if (common != null) {
            ElasticGiftsEntity elcommon = elasticGiftsDao.find(common.getElasticGiftsId());
            ElasticGiftsAppListDto commonDto = new ElasticGiftsAppListDto();
            commonDto.setIds(Collections.singletonList(common.getId()));
            commonDto.setBizCode(common.getBizCode());
            commonDto.setTitle4admin(elcommon == null ? "" :elcommon.getTitle4admin());
            commonDto.setElasticGiftsId(elcommon == null ? 0L : elcommon.getId());
            commonDto.setAppIdsStr(ElasticGiftsCommonAppEnum.COMMON.value() + "");
            commonDto.setAppIds(APP_COMMON_LIST);
            result.add(commonDto);
        }

        // 其他 app分组
        for (Long it : multimap.keySet()) {
            List<ElasticGiftsAppEntity> ens = (List<ElasticGiftsAppEntity>) multimap.get(it);
            ElasticGiftsEntity el = elasticGiftsDao.find(it);
            List<Long> ids = new ArrayList<>();
            List<Long> appIds = new ArrayList<>();
            for (ElasticGiftsAppEntity en : ens) {
                ids.add(en.getId());
                appIds.add(en.getAppId());
            }

            ElasticGiftsAppListDto dto = new ElasticGiftsAppListDto();
            dto.setIds(ids);
            dto.setElasticGiftsId(el.getId());
            dto.setBizCode(el.getBizCode());
            dto.setTitle4admin(el.getTitle4admin());
            dto.setAppIds(appIds);
            dto.setAppIdsStr(Joiner.on(",").join(appIds));
            result.add(dto);
        }
        return result;
    }

    @Override
    public Boolean delete(ElasticGiftsBizCodeEnum bizCode, List<Long> appIds) throws Exception {
        Preconditions.checkNotNull(bizCode, "业务编号不能为 null");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(appIds), "appIds不能为 null");
        if (appIds.contains(APP_COMMON_LIST.get(0))) {
            throw new Exception("共享库不能删除");
        }
        return elasticGiftsAppDao.deleteByBizCodeAndAppIds(bizCode.value(), appIds) > 0;
    }

    @Override
    public Boolean saveElasticGiftsIdByAppId(Long elasticGiftsId, Long appId, ElasticGiftsBizCodeEnum bizCode) {
        Preconditions.checkNotNull(elasticGiftsId, "活动 id不能为 null");
        Preconditions.checkNotNull(appId, "appId不能为 null");
        Preconditions.checkNotNull(bizCode, "业务编号不能为 null");
        ElasticGiftsAppEntity entity = elasticGiftsAppDao.findByBizCodeAndAppId(bizCode.value(), appId);
        if (entity == null) {
            ElasticGiftsAppEntity e4i = new ElasticGiftsAppEntity();
            e4i.setElasticGiftsId(elasticGiftsId);
            e4i.setBizCode(bizCode.value());
            e4i.setAppId(appId);
            return elasticGiftsAppDao.insert(e4i) > 0;
        } else {
            return elasticGiftsAppDao.updateElasticGiftsIdByAppId(elasticGiftsId, appId, bizCode.value()) > 0;
        }
    }

    @Override
    public List<ElasticGiftsAppSaveResultDto> save(List<Long> toDeleteIds, ElasticGiftsBizCodeEnum bizCode, List<Long> appIds, Long activityId) {
        Preconditions.checkNotNull(bizCode, "业务编号不能为 null");
        Preconditions.checkNotNull(activityId, "活动 id不能为 null");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(appIds), "appIds不能为 null");
        boolean deleteResult = true;
        if (CollectionUtils.isNotEmpty(toDeleteIds)) { // 判断有没有需要删除的 app 关系, 进了这里,表示是在更新的时候
            // 每次更新的时候,都需要把原来的app 和活动之间的关系都删掉,因为一旦不删掉,只要活动和 appid 已更新,原来的关系就丢掉了.不会被更新到.
            deleteResult = elasticGiftsAppDao.deleteByIds(toDeleteIds) > 0;
            if (!deleteResult && !appIds.contains(APP_COMMON_LIST.get(0))) {
                throw new RuntimeException("保存失败,请先回到列表页再进来编辑");
            }
        }
        List<ElasticGiftsAppSaveResultDto> result = new ArrayList<>();
        if (appIds.contains(APP_COMMON_LIST.get(0))) {
            elasticGiftsAppDao.updateElasticGiftsIdByAppId(activityId, APP_COMMON_LIST.get(0), bizCode.value());
            return result;
        }
        for (Long it : appIds) {
            AppDO app = remoteAppService.find(it);
            if (app == null) {
                result.add(ElasticGiftsAppSaveResultDto.failReuslt(it, ElasticGiftsAppSaveResultDto.APP_NOT_EXIST));
                continue;
            }
            try {
                ElasticGiftsAppEntity e4i = new ElasticGiftsAppEntity();
                e4i.setElasticGiftsId(activityId);
                e4i.setBizCode(bizCode.value());
                e4i.setAppId(it);
                int ret = elasticGiftsAppDao.insert(e4i);
                if (ret <= 0) {
                    throw new Exception("插入失败");
                }
                // result.add(ElasticGiftsAppSaveResultDto.successResult(it));  // 成功不展示
            } catch (Exception e) {
                LOGGER.error("保存失败", e.getMessage());
                result.add(ElasticGiftsAppSaveResultDto.failReuslt(it, ElasticGiftsAppSaveResultDto.APP_HAS_EXIST));
            }
        }
        return result;
    }
}
