/**
 * Project Name:activity-center-biz File Name:GameCenterResourceService.java Package
 * Name:cn.com.duiba.activity.center.biz.service.gamecenter Date:2016年10月20日下午2:13:24 Copyright (c) 2016, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.service.gamecenter;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterStatisticDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.LittleGameResourceListDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.RelatedActivityListDto;

/**
 * ClassName:GameCenterResourceService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 下午2:13:24 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public interface GameCenterResourceService {

    /**
     * findStatistic:管理端：查询游戏中心统计数据：小游戏数量，各个区域小游戏或活动数量. <br/>
     *
     * @author zhuzhiyong
     * @return the dubbo result
     * @throws GameCenterException the game center exception
     * @since JDK 1.6
     */
    GameCenterStatisticDto findStatistic() throws GameCenterException;

    /**
     * findLittleGameResource:管理端：查询小游戏列表. <br/>
     *
     * @author zhuzhiyong
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    LittleGameResourceListDto findLittleGameResource(Integer offset, Integer max);

    /**
     * updateResourceLocation:管理端：更新小游戏展示位. <br/>
     * 支持增删改，传递最终结果即可.<br/>
     *
     * @author zhuzhiyong
     * @param activityId the activity id
     * @param activityType the activity type
     * @param addLocationNames the add location names
     * @param delLocationNames the del location names
     * @return the dubbo result
     * @throws GameCenterException the game center exception
     */
    Boolean updateResourceLocation(Long activityId, Integer activityType, List<String> addLocationNames,
                                   List<String> delLocationNames) throws GameCenterException;

    /**
     * findRelatedActivity:管理端：查询关联的活动列表. <br/>
     *
     * @author zhuzhiyong
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    RelatedActivityListDto findRelatedActivity(Integer offset, Integer max) throws GameCenterException;

    /**
     * addRelatedActivity:管理端：关联活动. <br/>
     *
     * @author zhuzhiyong
     * @param activityId the activity id
     * @param activityType the activity type
     * @return the dubbo result
     */
    Boolean addRelatedActivity(Long activityId, Integer activityType) throws GameCenterException;

    /**
     * deleteRelatedActivity:管理端：取消关联活动. <br/>
     *
     * @author zhuzhiyong
     * @param activityId the activity id
     * @param activityType the activity type
     * @return the dubbo result
     */
    Boolean deleteRelatedActivity(Long activityId, Integer activityType);

    /**
     * findAvailableLittleGameByAppId:开发者端：查询展示的小游戏列表. <br/>
     * 过滤掉屏蔽记录.<br/>
     *
     * @author zhuzhiyong
     * @param appId the app id
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    LittleGameResourceListDto findAvailableLittleGameByAppId(Long appId, Integer offset, Integer max);

    /**
     * findHiddenLittleGameByAppId:查询开发者屏蔽的小游戏列表. <br/>
     *
     * @author zhuzhiyong
     * @param appId the app id
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    LittleGameResourceListDto findHiddenLittleGameByAppId(Long appId, Integer offset, Integer max);
}
